"""
Authors: Peter Mawhorter
Consulted:
Date: 2022-1-2
Purpose: Cheery melody example
  Demonstrates melody functions for mixedUpMelodies task.
"""

from wavesynth import *


def cheeryIntro():
    """
    A cheery intro melody. Leaves the pitch and volume at the same place
    it started. The notes added have a total duration of 2 seconds.
    """
    noteDuration = 0.25

    # Two quiet notes with rests afterwards
    quieter(2)
    addNote(noteDuration)
    addRest(noteDuration)

    addNote(noteDuration)
    addRest(noteDuration)
    louder(1)

    # Two notes with the second a full step up
    addNote(noteDuration)
    louder(1)
    halfStepUp(2)
    addNote(noteDuration)

    # Back to base pitch
    halfStepDown(2)

    # A chord at the end
    addNote(noteDuration * 2)
    rewind(noteDuration * 2)
    quieter(3)
    halfStepUp(4)
    addNote(noteDuration * 2)

    # return to original pitch/volume
    halfStepDown(4)
    louder(3)


def perfectFifth(duration):
    """
    Adds a pair of notes separated by 7 half-steps, which is called a
    "perfect 5th". The higher note is made a bit quieter. The pitch and
    volume are set back to their original values at the end.
    """
    addNote(duration)
    rewind(duration)

    quieter(3)
    halfStepUp(7)
    addNote(duration)

    # Restore original pitch/volume
    halfStepDown(7)
    louder(3)


def cheeryRefrain():
    """
    A cheery refrain. The last note isn't the same as the first one, but
    this function returns the current pitch value back to where it
    started in the end, and it also leaves the volume unchanged. Total
    duration is 2 seconds.
    """
    noteDuration = 0.25

    # Notes moving up and then down the parts of a major chord
    addNote(noteDuration)
    halfStepUp(4)
    addNote(noteDuration)
    halfStepUp(3)
    addNote(noteDuration)
    halfStepDown(3)
    addNote(noteDuration)
    halfStepDown(4)
    addNote(noteDuration)

    # one step up the major chord again
    halfStepUp(4)
    addNote(noteDuration)

    # one full-step down and we add a chord
    halfStepDown(2)
    perfectFifth(noteDuration * 2)

    halfStepDown(2) # return to initial pitch


def cheeryEnding():
    """
    A cheery ending. Ends on the same note it started on, with the volume
    unchanged. Total duration is 2 seconds.
    """
    noteDuration = 0.25

    # Base note plus three falling notes back to the base pitch
    addNote(noteDuration)
    halfStepUp(4)
    addNote(noteDuration)
    halfStepDown(2)
    addNote(noteDuration)
    halfStepDown(2)
    addNote(noteDuration)

    # Two notes from below up towards the base pitch
    halfStepDown(3)
    addNote(noteDuration)
    halfStepUp(2)
    addNote(noteDuration)
    halfStepUp(1)

    # A chord at the end starting from the base pitch
    addNote(noteDuration * 2)
    rewind(noteDuration * 2)
    quieter(3)
    halfStepUp(4)
    addNote(noteDuration * 2)

    # Return to original pitch + volume
    halfStepDown(4)
    louder(3)

