"""
Authors: Peter Mawhorter
Consulted:
Date: 2022-1-24
Purpose: Testing code for mathPractice.py debugging task
"""

import optimism as opt

# This first part of the code runs a test that uses the same input as the
# first example in the instructions. Note that only the first two input
# values actually matter in terms of the math being done. If this check
# fails but you're not sure where, try using this website to compare the
# output you see to the output from the example in the instructions:
#   https://www.diffchecker.com/
# (note: you don't have to sign up; it's free)
manager = opt.testFile("mathPractice.py")
case1 = manager.case()
case1.provideInputs("15", "7", "22", "8", "90", "2", "I don't know.")
case1.checkOutputLines(
    "Let's practice some math!",
    "Enter an integer between 1 and 20: 15",
    "Enter another integer between 1 and 20: 7",
    "",
    "The numbers you entered are 15 and 7",
    "The larger number is 15",
    "The smaller number is 7",
    "These bars show how big they are:",
    "===============",
    "=======",
    "",
    "[Addition] What is 15+7 ? 22",
    "[Addition] The answer is: 22",
    "",
    "[Subtraction] What is 15-7 ? 8",
    "[Subtraction] The answer is: 8",
    "",
    "[Multiplication] What is 15*7 ? 90",
    "[Multiplication] The answer is: 105",
    "",
    "[Division] What is 15/7 (rounded to an integer)? 2",
    "[Division] The answer is: 2",
    "",
    "[Remainder] What is the remainder of 15/7 ? I don't know.",
    "[Remainder] The answer is: 1"
)

# Here's a second test, which corresponds to the second example.
case2 = manager.case()
case2.provideInputs("12", "3", "15", "Nine", "36", "Four", "nothing")
case2.checkOutputLines(
    "Let's practice some math!",
    "Enter an integer between 1 and 20: 12",
    "Enter another integer between 1 and 20: 3",
    "",
    "The numbers you entered are 12 and 3",
    "The larger number is 12",
    "The smaller number is 3",
    "These bars show how big they are:",
    "============",
    "===",
    "",
    "[Addition] What is 12+3 ? 15",
    "[Addition] The answer is: 15",
    "",
    "[Subtraction] What is 12-3 ? Nine",
    "[Subtraction] The answer is: 9",
    "",
    "[Multiplication] What is 12*3 ? 36",
    "[Multiplication] The answer is: 36",
    "",
    "[Division] What is 12/3 (rounded to an integer)? Four",
    "[Division] The answer is: 4",
    "",
    "[Remainder] What is the remainder of 12/3 ? nothing",
    "[Remainder] The answer is: 0"
)

# Below is a third test which just runs the code without checking the
# result. You can edit these two variables to specify the numbers to use
# for this test, but you'll have to check the results by hand.
num1 = 10
num2 = 10

case3 = manager.case()
case3.provideInputs(str(num1), str(num2), "", "", "", "", "", "")
case3.showOutput()
case3.run()
