"""
Authors:
Consulted:
Date:
Purpose:  measureMunger task: creates, sorts, and filters lists & then
    make music based on them.
"""

from wavesynth import *

import math


#-------------------------------------------#
# Provided functions & data (DO NOT CHANGE) #
#-------------------------------------------#


# This changes how climbUp and climbDown behave
setFundamental("C")
setScaleType("Pentatonic-Major")


def pitchReachedFromC4(interval, notes, goingUp):
    """
    Returns the pitch of the last note of an arpeggio going either up or
    down from C4 (depending on whether `goingUp` is True or False). The
    given interval and number of notes define how far we go; we assume a
    pentatonic major scale with C as the fundamental note.
    """
    setFundamental("C")
    setScaleType("Pentatonic-Major")
    base = C4
    if goingUp:
        return climbUpFrom(C4, interval * notes)
    else:
        return climbDownFrom(C4, interval * notes)


def pitchSpanFromC4(interval, notes, goingUp):
    """
    Like `pitchReachedFromC4` but returns the ratio between the top &
    bottom pitches of the arpeggio.

    The ratio is always >= 1, and expresses the total pitch span of the
    arpeggio.
    """
    reached = pitchReachedFromC4(interval, notes, goingUp)
    if reached > C4:
        return reached / C4
    else:
        return C4 / reached


def customMeasure(interval, notes, goingUp):
    """
    Adds notes for a custom measure to the current track. The measure is
    an arpeggio that starts with one note at the current pitch and then
    moves up (or down, if `goingUp` is False) by the given `interval`
    between each note, with `notes` dictating the total number of notes.
    Each note uses 0.2 as its duration.

    This changes the current pitch to one interval beyond the last note
    of the arpeggio, which means that successive arpeggios build on each
    other.
    """
    for i in range(notes):
        addNote(0.2)
        if goingUp:
            climbUp(interval)
        else:
            climbDown(interval)


# Note: this depends on *your* implementation of addMeasureSequence and
# various sorting functions.
def tuneTest():
    """
    Draws the three lists of polygons sorted in different ways.
    """
    runsUp = makeRunsList([3, 4, 2])
    sortBySpan(runsUp)
    addMeasureSequence(runsUp, C4, 0)
    triplesUp = measuresThatReach(
        makeTriplesList(True, [1, 2, 3, 2, 4]),
        A5
    )
    sortBySpan(triplesUp)
    addMeasureSequence(triplesUp, C3, 1) # start low; overlap a lot
    someDowns = oddNotesMeasures(
        makeListWithDirections(
            [
                (3, 3),
                (4, 2),
                (6, 4),
                (8, 2),
                (5, 1)
            ],
            False
        )
    )
    sortByInterval(someDowns, False)
    addMeasureSequence(someDowns, E5, 2) # start high; overlap later
    mixedMeasures = makeMeasuresList(
        [1, 3, 1, 2, 3],
        [4, 3, 5, 4, 3],
        [True, False, False, True, False]
    )
    sortBySpan(mixedMeasures)
    addMeasureSequence(mixedMeasures, A4, 3)
    filtered = measuresInDirection(mixedMeasures, True)
    sortByInterval(filtered, True)
    addMeasureSequence(filtered, C4, 5)
    # one last longer note to finish it off
    addNote(0.6)


#----------------#
# Your code here #
#----------------#
