"""
Authors: Peter Mawhorter
Consulted:
Date: 2025-1-18
Purpose: Tests for the quadrats task.
"""

import optimism

import quadrats

smallSquare = [
    [1, 3],
    [0, 5]
]
twins = [
    [1],
    [1]
]
empty = [
    [0, 0, 0],
    [0, 0, 0],
    [0, 0, 0]
]
populated = [
    [0, 2, 0],
    [0, 1, 2],
    [1, 1, 1]
]
spread = [
    [0, 5, 3, 3],
    [2, 3, 4, 6],
    [6, 4, 2, 1],
    [3, 0, 4, 2]
]
isolated = [
    [0, 1, 1, 0],
    [2, 0, 0, 4],
    [0, 0, 2, 0],
    [2, 0, 0, 0],
    [0, 1, 2, 0]
]
lonely = [
    [1]
]

# Tests for totalCount
optimism.freshTestSuite('totalCount')
testTC = optimism.testFunctionMaybe(quadrats, "totalCount")
testTC.case(smallSquare).checkReturnValue(9)
testTC.case(twins).checkReturnValue(2)
testTC.case(empty).checkReturnValue(0)
testTC.case(populated).checkReturnValue(8)
testTC.case(spread).checkReturnValue(48)
testTC.case(isolated).checkReturnValue(15)
testTC.case(lonely).checkReturnValue(1)

# Tests for inhabitedCells
optimism.freshTestSuite('inhabitedCells')
testIC = optimism.testFunctionMaybe(quadrats, "inhabitedCells")
testIC.case(smallSquare).checkReturnValue(3)
testIC.case(twins).checkReturnValue(2)
testIC.case(empty).checkReturnValue(0)
testIC.case(populated).checkReturnValue(6)
testIC.case(spread).checkReturnValue(14)
testIC.case(isolated).checkReturnValue(8)
testIC.case(lonely).checkReturnValue(1)

# Tests for highestCount
optimism.freshTestSuite('highestCount')
testHC = optimism.testFunctionMaybe(quadrats, "highestCount")
testHC.case(smallSquare).checkReturnValue(5)
testHC.case(twins).checkReturnValue(1)
testHC.case(empty).checkReturnValue(0)
testHC.case(populated).checkReturnValue(2)
testHC.case(spread).checkReturnValue(6)
testHC.case(isolated).checkReturnValue(4)
testHC.case(lonely).checkReturnValue(1)

# Tests for highestThree
optimism.freshTestSuite('highestThree')
testHT = optimism.testFunctionMaybe(quadrats, "highestThree")
testHT.case(smallSquare).checkReturnValue([5, 3, 1])
testHT.case(twins).checkReturnValue([1, 1, 0])
testHT.case(empty).checkReturnValue([0, 0, 0])
testHT.case(populated).checkReturnValue([2, 2, 1])
testHT.case(spread).checkReturnValue([6, 6, 5])
testHT.case(isolated).checkReturnValue([4, 2, 2])
testHT.case(lonely).checkReturnValue([1, 0, 0])

# Tests for squaresCount
optimism.freshTestSuite('squaresCount')
testSC = optimism.testFunctionMaybe(quadrats, "squaresCount")
testSC.case(smallSquare).checkReturnValue(0)
testSC.case(twins).checkReturnValue(0)
testSC.case(empty).checkReturnValue(0)
testSC.case(populated).checkReturnValue(1)
testSC.case(spread).checkReturnValue(6)
testSC.case(isolated).checkReturnValue(0)
testSC.case(lonely).checkReturnValue(0)

# Tests for isolatedCount
optimism.freshTestSuite('isolatedCount')
testICt = optimism.testFunctionMaybe(quadrats, "isolatedCount")
testICt.case(smallSquare).checkReturnValue(0)
testICt.case(twins).checkReturnValue(0)
testICt.case(empty).checkReturnValue(0)
testICt.case(populated).checkReturnValue(0)
testICt.case(spread).checkReturnValue(0)
testICt.case(isolated).checkReturnValue(4)
testICt.case(lonely).checkReturnValue(1)

# Show summary at the end
optimism.showOverview()
