"""
Authors: Peter Mawhorter
Consulted:
Date: 2022-4-26
Purpose: Testing code for recursive genetics task.
"""

import optimism

import recursiveGenetics

testCOB = optimism.testFunctionMaybe(recursiveGenetics, "countOtherBases")
testCOB.case("GAUUACA", "A").checkReturnValue(4)
testCOB.case("GAUUACA", "G").checkReturnValue(6)
testCOB.case("AAA", "G").checkReturnValue(3)
testCOB.case("AAA", "A").checkReturnValue(0)
testCOB.case("", "G").checkReturnValue(0)

testTS = optimism.testFunctionMaybe(recursiveGenetics, "templateSequence")
testTS.case("GACU").checkReturnValue("CTGA")
testTS.case("AAA").checkReturnValue("TTT")
testTS.case("UUU").checkReturnValue("AAA")

testOAU = optimism.testFunctionMaybe(recursiveGenetics, "onlyAU")
testOAU.case("GUACGU").checkReturnValue("UAU")
testOAU.case("AAU").checkReturnValue("AAU")
testOAU.case("GCC").checkReturnValue("")

testTE = optimism.testFunctionMaybe(recursiveGenetics, "transcriptionErrors")
testTE.case("AAA", "TTC").checkReturnValue(1)
testTE.case("AAG", "TTC").checkReturnValue(0)
testTE.case("CAGUAGG", "CTCAACC").checkReturnValue(2)

testPSSW = optimism.testFunctionMaybe(
    recursiveGenetics,
    "printSequencesStartingWith"
)
testPSSW.case('', 1).checkPrintedLines('A', 'C', 'G', 'U')
testPSSW.case('A', 1).checkPrintedLines('A')
testPSSW.case('AA', 1).checkPrintedLines('AA')
testPSSW.case('CCG', 4).checkPrintedLines('CCGA', 'CCGC', 'CCGG', 'CCGU')
testPSSW.case('A', 3).checkPrintedLines(
    'AAA',
    'AAC',
    'AAG',
    'AAU',
    'ACA',
    'ACC',
    'ACG',
    'ACU',
    'AGA',
    'AGC',
    'AGG',
    'AGU',
    'AUA',
    'AUC',
    'AUG',
    'AUU'
)


testLSSW = optimism.testFunctionMaybe(
    recursiveGenetics,
    "listSequencesStartingWith"
)
testLSSW.case('', 1).checkReturnValue(['A', 'C', 'G', 'U'])
testLSSW.case('A', 1).checkReturnValue(['A'])
testLSSW.case('AA', 1).checkReturnValue(['AA'])
testLSSW.case('A', 2).checkReturnValue(['AA', 'AC', 'AG', 'AU'])
testLSSW.case('CCG', 4).checkReturnValue(['CCGA', 'CCGC', 'CCGG', 'CCGU'])
testLSSW.case('AUCG', 6).checkReturnValue([
    'AUCGAA',
    'AUCGAC',
    'AUCGAG',
    'AUCGAU',
    'AUCGCA',
    'AUCGCC',
    'AUCGCG',
    'AUCGCU',
    'AUCGGA',
    'AUCGGC',
    'AUCGGG',
    'AUCGGU',
    'AUCGUA',
    'AUCGUC',
    'AUCGUG',
    'AUCGUU',
])
