"""
Authors: Peter Mawhorter
Consulted:
Date: 2022-4-19
Purpose: Tests for the recursiveScales task which makes ascending note
  sequences.
"""

import optimism

import wavesynth

import recursiveScales

if hasattr(recursiveScales, "scale"):
    for (startingPitch, duration, notes, result) in [
        ("C4", 1, 4, ["C4", "D4", "E4", "F4"]),
        ("D4", 1.5, 6, ["D4", "E4", "F4", "G4", "A4", "B4"]),
        ("A3", 2, 5, ["A3", "B3", "C4", "D4", "E4"])
    ]:
        block = f"""\
wavesynth.setPitch(wavesynth.{startingPitch})
recursiveScales.scale({duration}, {notes})
wavesynth.printTrack()
wavesynth.playTrack()"""
        wavesynth.resetTracks()
        tester = optimism.testBlock(block)
        noteDuration = round(duration / notes, 3)
        tester.case(
            wavesynth=wavesynth,
            recursiveScales=recursiveScales
        ).checkPrintedLines(
            f"a {noteDuration}s keyboard note at {result[0]} (60% vol)",
            *[
                f"and a {noteDuration}s keyboard note at {pitch} (60% vol)"
                for pitch in result[1:]
            ]
        )
else:
    print("Skipping tests for function 'scale' (not defined yet)")


if hasattr(recursiveScales, "unevenScale"):
    for (startingPitch, notes, startDuration, otherDuration, result) in [
        (
            "C4", 4, 0.5, 0.25,
            [("C4", 0.5), ("D4", 0.25), ("E4", 0.5), ("F4", 0.25)]
        ),
        (
            "C4", 5, 0.5, 0.25,
            [("C4", 0.5), ("D4", 0.25), ("E4", 0.5), ("F4", 0.25), ("G4", 0.5)]
        ),
        (
            "A4", 7, 0.2, 0.15,
            [
                ("A4", 0.2),
                ("B4", 0.15),
                ("C5", 0.2),
                ("D5", 0.15),
                ("E5", 0.2),
                ("F5", 0.15),
                ("G5", 0.2),
            ]
        ),
    ]:
        block = f"""\
wavesynth.setPitch(wavesynth.{startingPitch})
recursiveScales.unevenScale({notes}, {startDuration}, {otherDuration})
wavesynth.printTrack()
wavesynth.playTrack()"""
        wavesynth.resetTracks()
        tester = optimism.testBlock(block)
        tester.case(
            wavesynth=wavesynth,
            recursiveScales=recursiveScales
        ).checkPrintedLines(
            f"a {result[0][1]}s keyboard note at {result[0][0]} (60% vol)",
            *[
                f"and a {duration}s keyboard note at {pitchName} (60% vol)"
                for (pitchName, duration) in result[1:]
            ]
        )
else:
    print("Skipping tests for function 'unevenScale' (not defined yet)")


if hasattr(recursiveScales, "rungsListMelody"):
    for (startingPitch, duration, intervals) in [
        ("C4", 1, [2, 2, 3]),
        ("D4", 1.4, [2, 2, 3, -3, -2, -2]),
        ("A4", 0.8, [2])
    ]:
        block = f"""\
wavesynth.setPitch(wavesynth.{startingPitch})
recursiveScales.rungsListMelody({duration}, {intervals})
wavesynth.printTrack()
wavesynth.playTrack()"""
        wavesynth.resetTracks()
        tester = optimism.testBlock(block)
        eachDuration = round(duration / (len(intervals) + 1), 3)
        pitchNow = getattr(wavesynth, startingPitch)
        pitchNames = []
        for interval in intervals:
            pitchNames.append(wavesynth.pitchName(pitchNow))
            pitchNow = wavesynth.climbUpFrom(pitchNow, interval)
        pitchNames.append(wavesynth.pitchName(pitchNow))

        tester.case(
            wavesynth=wavesynth,
            recursiveScales=recursiveScales
        ).checkPrintedLines(
            f"a {eachDuration}s keyboard note at {pitchNames[0]} (60% vol)",
            *[
                f"and a {eachDuration}s keyboard note at {pname} (60% vol)"
                for pname in pitchNames[1:]
            ]
        )
else:
    print("Skipping tests for function 'rungsListMelody' (not defined yet)")
