"""
Authors: Peter Mawhorter
Consulted:
Date: 2022-04-12
Purpose: Defines data values that will result from loading JSON files so
  we can test them.
"""

soloYelpLoaded = {
  "XguKrY0dAuaK1W6HUlUQ1Q": {'state': 'OH', 'address': '547 Sackett Ave', 'review_count': 29, 'stars': 3.5, 'name': "Retz's Laconi's II", 'city': 'Cuyahoga Falls', 'categories': ['Italian', 'Restaurants', 'Pizza']}
}

microYelpLoaded = {
  "PMH4oUa-bWELKogdtkWewg": {'state': 'ON', 'address': '100 City Centre Dr', 'review_count': 16, 'stars': 2.0, 'name': 'GoodLife Fitness', 'city': 'Mississauga', 'categories': ['Fitness & Instruction', 'Sports Clubs', 'Gyms', 'Trainers', 'Active Life']},
  "XguKrY0dAuaK1W6HUlUQ1Q": {'state': 'OH', 'address': '547 Sackett Ave', 'review_count': 29, 'stars': 3.5, 'name': "Retz's Laconi's II", 'city': 'Cuyahoga Falls', 'categories': ['Italian', 'Restaurants', 'Pizza']},
  "Wpt0sFHcPtV5MO9He7yMKQ": {'state': 'NV', 'address': '3020 E Desert Inn Rd', 'review_count': 20, 'stars': 2.0, 'name': "McDonald's", 'city': 'Las Vegas', 'categories': ['Restaurants', 'Fast Food', 'Burgers']},
  "1K4qrnfyzKzGgJPBEcJaNQ": {'state': 'ON', 'address': '1058 Gerrard Street E', 'review_count': 39, 'stars': 3.5, 'name': 'Chula Taberna Mexicana', 'city': 'Toronto', 'categories': ['Tiki Bars', 'Nightlife', 'Mexican', 'Restaurants', 'Bars']},
  "7gquCdaFoHZCcLYDttpHtw": {'state': 'SC', 'address': '8439 Charlotte Hwy', 'review_count': 17, 'stars': 4.0, 'name': 'Bubbly Nails', 'city': 'Fort Mill', 'categories': ['Nail Salons', 'Beauty & Spas']},
  "Mmh4w2g2bSAkdSAFd_MH_g": {'state': 'SC', 'address': '845 Stockbridge Dr', 'review_count': 77, 'stars': 3.0, 'name': 'Red Bowl', 'city': 'Fort Mill', 'categories': ['Restaurants', 'Asian Fusion']},
  "vMO2vNyWLuxumso7t3rbYw": {'state': 'ON', 'address': '300 Borough Drive', 'review_count': 5, 'stars': 4.0, 'name': "Pablo's Grill It Up", 'city': 'Scarborough', 'categories': ['Food Court', 'Restaurants', 'Barbeque']},
  "h2XsV6mR6c7QURhlsi0RqA": {'state': 'AZ', 'address': '211 E 10th Dr, Ste 2', 'review_count': 26, 'stars': 4.5, 'name': "John's Refrigeration Heating and Cooling", 'city': 'Mesa', 'categories': ['Home Services', 'Air Duct Cleaning', 'Local Services', 'Heating & Air Conditioning/HVAC']},
  "c6Q3HP4cmWZbD9GX8kr4IA": {'state': 'NC', 'address': '4837 N Tryon St', 'review_count': 8, 'stars': 3.5, 'name': 'Pep Boys', 'city': 'Charlotte', 'categories': ['Auto Parts & Supplies', 'Auto Repair', 'Tires', 'Automotive']},
  "1EuqKW-JC-Fm3RSWRqKdrg": {'state': 'NV', 'address': '2075 E Warm Springs Rd', 'review_count': 5, 'stars': 5.0, 'name': 'Life Springs Christian Church', 'city': 'Las Vegas', 'categories': ['Religious Organizations', 'Churches']},
  "VZ37HCZVruFm-w_Mkl1aEQ": {'state': 'AZ', 'address': '13637 N Tatum Blvd, Ste 8', 'review_count': 16, 'stars': 5.0, 'name': 'Conservatory of Dance', 'city': 'Phoenix', 'categories': ['Education', 'Dance Schools', 'Arts & Entertainment', 'Fitness & Instruction', 'Specialty Schools', 'Active Life', 'Dance Studios', 'Performing Arts']},
  "htKaC4cHY4wlB4Wqb8CDnQ": {'state': 'PA', 'address': '4730 Liberty Ave', 'review_count': 4, 'stars': 4.0, 'name': 'Allure', 'city': 'Pittsburgh', 'categories': ['Accessories', "Women's Clothing", 'Fashion', 'Shopping']},
  "7fiIMBxbOYdAv3XMcmWivw": {'state': 'OH', 'address': '850 Euclid Ave', 'review_count': 3, 'stars': 3.0, 'name': "Renee's Relaxation and Body Mechanics", 'city': 'Cleveland', 'categories': ['Massage', 'Beauty & Spas']},
  "4SBY4CHiMD8YOCEU9_fdnw": {'state': 'ON', 'address': '123 Queen Street W', 'review_count': 3, 'stars': 4.0, 'name': 'Fidora Salon and Spa', 'city': 'Toronto', 'categories': ['Day Spas', 'Hair Salons', 'Beauty & Spas']},
  "6aFAEeJ3nS-iWGt7Tn7S0Q": {'state': 'NC', 'address': '19925 Jetton Rd, Ste 100', 'review_count': 5, 'stars': 5.0, 'name': 'KS Audio Video', 'city': 'Cornelius', 'categories': ['Home Services', 'Television Service Providers', 'Home Automation', 'Home Theatre Installation', 'Professional Services']},
}

pizzaYelpLoaded = {
  "MyiqKhZd8N08q9qilxRcPQ": {"address": "20124 W Catawba", "categories": ["Food", "Bakeries", "Restaurants", "Pizza"], "city": "Cornelius", "name": "Our Daily Bread", "stars": 4.0, "review_count": 5, "state": "NC"},
  "__sXvAzVGUsK6AyzT19v6g": {"address": "890 Butler St", "categories": ["Food", "Caterers", "Italian", "Event Planning & Services", "Pasta Shops", "Restaurants", "Specialty Food", "Pizza"], "city": "Pittsburgh", "name": "Pizza & Pasta Villa", "stars": 1.5, "review_count": 15, "state": "PA"},
  "vc0v-vOIwWpa8eA9Fcc2zQ": {"address": "14845 Yonge Street", "categories": ["Pizza", "Restaurants"], "city": "Aurora", "name": "Pizza Nova", "stars": 3.5, "review_count": 4, "state": "ON"},
  "VDcfkHSR_Asv3onUsfBTqA": {"address": "10339 Perry Hwy", "categories": ["Sandwiches", "Wraps", "Food", "Food Delivery Services", "Delis", "Pizza", "Restaurants"], "city": "Wexford", "name": "Freedom Pizza & Deli", "stars": 4.0, "review_count": 10, "state": "PA"},
  "ESC1tS28OueKX5akvrM_Ww": {"address": "6428 Pearl Rd", "categories": ["Restaurants", "Italian", "Pizza", "Chicken Wings"], "city": "Parma Heights", "name": "Pizza Hut", "stars": 1.5, "review_count": 11, "state": "OH"},
  "DQDeGKxYVOwwaqN6Jh2HZw": {"address": "4030 E Thunderbird Rd", "categories": ["Italian", "Restaurants", "Pizza"], "city": "Phoenix", "name": "Papa John's Pizza", "stars": 2.0, "review_count": 26, "state": "AZ"},
  "aGA_iSHm9laGTrfPLJG1yw": {"address": "6821 W Peoria Ave", "categories": ["Chicken Wings", "Buffets", "Restaurants", "Pizza"], "city": "Peoria", "name": "Peter Piper Pizza", "stars": 2.5, "review_count": 39, "state": "AZ"},
  "RZ1xA8iB9crWjv3fG0gMhg": {"address": "7610 Centrale Rue", "categories": ["Pizza", "Restaurants"], "city": "Lasalle", "name": "Restaurant Centrale Pizzeria", "stars": 4.0, "review_count": 8, "state": "QC"},
  "wKQthQiyzj1vxwkpLNWzTA": {"address": "15557 West Bell Road", "categories": ["Restaurants", "Pizza"], "city": "Surprise", "name": "Papa Murphy's", "stars": 4.0, "review_count": 30, "state": "AZ"},
  "kGVAle6VpDvZHlEeTB2WhA": {"address": "8480 S Las Vegas, Ste 110", "categories": ["Delis", "Restaurants", "Sandwiches", "Food", "Pizza"], "city": "Las Vegas", "name": "Deliria", "stars": 4.0, "review_count": 10, "state": "NV"}
}

miniYelpLoaded = {
  "PMH4oUa-bWELKogdtkWewg": {"state": "ON", "address": "100 City Centre Dr", "review_count": 16, "stars": 2.0, "name": "GoodLife Fitness", "city": "Mississauga", "categories": ["Fitness & Instruction", "Sports Clubs", "Gyms", "Trainers", "Active Life"]},
  "XguKrY0dAuaK1W6HUlUQ1Q": {"state": "OH", "address": "547 Sackett Ave", "review_count": 29, "stars": 3.5, "name": "Retz's Laconi's II", "city": "Cuyahoga Falls", "categories": ["Italian", "Restaurants", "Pizza"]},
  "Wpt0sFHcPtV5MO9He7yMKQ": {"state": "NV", "address": "3020 E Desert Inn Rd", "review_count": 20, "stars": 2.0, "name": "McDonald's", "city": "Las Vegas", "categories": ["Restaurants", "Fast Food", "Burgers"]},
  "1K4qrnfyzKzGgJPBEcJaNQ": {"state": "ON", "address": "1058 Gerrard Street E", "review_count": 39, "stars": 3.5, "name": "Chula Taberna Mexicana", "city": "Toronto", "categories": ["Tiki Bars", "Nightlife", "Mexican", "Restaurants", "Bars"]},
  "7gquCdaFoHZCcLYDttpHtw": {"state": "SC", "address": "8439 Charlotte Hwy", "review_count": 17, "stars": 4.0, "name": "Bubbly Nails", "city": "Fort Mill", "categories": ["Nail Salons", "Beauty & Spas"]},
  "Mmh4w2g2bSAkdSAFd_MH_g": {"state": "SC", "address": "845 Stockbridge Dr", "review_count": 77, "stars": 3.0, "name": "Red Bowl", "city": "Fort Mill", "categories": ["Restaurants", "Asian Fusion"]},
  "vMO2vNyWLuxumso7t3rbYw": {"state": "ON", "address": "300 Borough Drive", "review_count": 5, "stars": 4.0, "name": "Pablo's Grill It Up", "city": "Scarborough", "categories": ["Food Court", "Restaurants", "Barbeque"]},
  "h2XsV6mR6c7QURhlsi0RqA": {"state": "AZ", "address": "211 E 10th Dr, Ste 2", "review_count": 26, "stars": 4.5, "name": "John's Refrigeration Heating and Cooling", "city": "Mesa", "categories": ["Home Services", "Air Duct Cleaning", "Local Services", "Heating & Air Conditioning/HVAC"]},
  "c6Q3HP4cmWZbD9GX8kr4IA": {"state": "NC", "address": "4837 N Tryon St", "review_count": 8, "stars": 3.5, "name": "Pep Boys", "city": "Charlotte", "categories": ["Auto Parts & Supplies", "Auto Repair", "Tires", "Automotive"]},
  "1EuqKW-JC-Fm3RSWRqKdrg": {"state": "NV", "address": "2075 E Warm Springs Rd", "review_count": 5, "stars": 5.0, "name": "Life Springs Christian Church", "city": "Las Vegas", "categories": ["Religious Organizations", "Churches"]},
  "VZ37HCZVruFm-w_Mkl1aEQ": {"state": "AZ", "address": "13637 N Tatum Blvd, Ste 8", "review_count": 16, "stars": 5.0, "name": "Conservatory of Dance", "city": "Phoenix", "categories": ["Education", "Dance Schools", "Arts & Entertainment", "Fitness & Instruction", "Specialty Schools", "Active Life", "Dance Studios", "Performing Arts"]},
  "htKaC4cHY4wlB4Wqb8CDnQ": {"state": "PA", "address": "4730 Liberty Ave", "review_count": 4, "stars": 4.0, "name": "Allure", "city": "Pittsburgh", "categories": ["Accessories", "Women's Clothing", "Fashion", "Shopping"]},
  "7fiIMBxbOYdAv3XMcmWivw": {"state": "OH", "address": "850 Euclid Ave", "review_count": 3, "stars": 3.0, "name": "Renee's Relaxation and Body Mechanics", "city": "Cleveland", "categories": ["Massage", "Beauty & Spas"]},
  "4SBY4CHiMD8YOCEU9_fdnw": {"state": "ON", "address": "123 Queen Street W", "review_count": 3, "stars": 4.0, "name": "Fidora Salon and Spa", "city": "Toronto", "categories": ["Day Spas", "Hair Salons", "Beauty & Spas"]},
  "6aFAEeJ3nS-iWGt7Tn7S0Q": {"state": "NC", "address": "19925 Jetton Rd, Ste 100", "review_count": 5, "stars": 5.0, "name": "KS Audio Video", "city": "Cornelius", "categories": ["Home Services", "Television Service Providers", "Home Automation", "Home Theatre Installation", "Professional Services"]},
  "FfI9FOaQqzUxixw6_glt3Q": {"state": "AZ", "address": "3655 W Anthem Way, Ste C-137", "review_count": 6, "stars": 3.0, "name": "Affinito's Bistro", "city": "Phoenix", "categories": ["Restaurants", "Italian"]},
  "naHOPNUhSnrHmzWCQ2bWyA": {"state": "NV", "address": "2704 N Tenaya Way", "review_count": 49, "stars": 3.0, "name": "Southwest Medical Associates at Tenaya", "city": "Las Vegas", "categories": ["Doctors", "Midwives", "Urgent Care", "Health & Medical", "Medical Centers"]},
  "ok38fApaT1TBEU-IH85BvA": {"state": "AZ", "address": "3245 W Florimond Rd", "review_count": 5, "stars": 5.0, "name": "Kool Pool Care & Repair", "city": "Phoenix", "categories": ["Home Services", "Contractors", "Pool & Hot Tub Service", "Pool Cleaners"]},
  "LOeVGnlOti05f86ZZbgY7Q": {"state": "PA", "address": "540 McNeilly Rd", "review_count": 3, "stars": 3.5, "name": "Coyle Auto Body", "city": "Pittsburgh", "categories": ["Automotive", "Auto Repair", "Body Shops"]},
  "7SBM_0TcfYTs2oMD-vgaQA": {"state": "AZ", "address": "4424 W Peoria Ave", "review_count": 3, "stars": 3.5, "name": "R-ATV", "city": "Glendale", "categories": ["Automotive", "Motorcycle Repair"]},
  "A_Ij4SwFmlRbVtRnsdSzWA": {"state": "AZ", "address": "15041 N Airport Dr", "review_count": 5, "stars": 2.0, "name": "Ciao Baby Catering", "city": "Scottsdale", "categories": ["Event Planning & Services", "Caterers"]},
  "NOHh2pgOTUBqp82IQlRQMQ": {"state": "ON", "address": "1928 McCowan Road", "review_count": 110, "stars": 3.5, "name": "Panagio's All Day Grill", "city": "Scarborough", "categories": ["Canadian (New)", "Restaurants", "Breakfast & Brunch"]},
  "d6ngz4WmMaQL8Xdfur7bwQ": {"state": "AZ", "address": "15825 W Redfield Rd", "review_count": 5, "stars": 4.5, "name": "Crazy Kleen Carpet Cleaning", "city": "Surprise", "categories": ["Office Cleaning", "Carpet Cleaning", "Professional Services", "Home Cleaning", "Home Services", "Local Services"]},
  "c6Shr51XcbvAeXp6hb_Exg": {"state": "AZ", "address": "2222 E Highland Ave, Ste 300", "review_count": 18, "stars": 2.0, "name": "Christopher Huston, MD - TOCA", "city": "Phoenix", "categories": ["Orthopedists", "Health & Medical", "Doctors"]},
  "EiZYdEo9p2K6r6CnZ5gqsw": {"state": "AZ", "address": "333 S. Nina Dr", "review_count": 28, "stars": 4.0, "name": "Mr. Rooter Plumbing of Phoenix Arizona", "city": "Mesa", "categories": ["Plumbing", "Home Services"]},
  "EfYExaDrwhj0k611u5lYMg": {"state": "AZ", "address": "4307 W Glendale Ave", "review_count": 12, "stars": 2.0, "name": "G G & D Motor Vehicle Services", "city": "Glendale", "categories": ["Shopping", "Public Services & Government", "Departments of Motor Vehicles"]},
  "Sx0C2RsDgrG3RxBBUoBqTw": {"state": "NV", "address": "3228 Meade Ave", "review_count": 9, "stars": 3.5, "name": "Kool Radiator Service", "city": "Las Vegas", "categories": ["Automotive", "Auto Repair"]},
  "ualXxlORdVbDlW-Ukww0QQ": {"state": "PA", "address": "10551 Perry Hwy", "review_count": 4, "stars": 3.0, "name": "Monro Muffler Brake & Service", "city": "Wexford", "categories": ["Auto Repair", "Oil Change Stations", "Tires", "Automotive"]},
  "ctVYi8RmzXbNfw9syXH1kg": {"state": "AZ", "address": "500 W Southern Ave, Ste 1", "review_count": 43, "stars": 4.5, "name": "Dental Brothers", "city": "Mesa", "categories": ["Health & Medical", "Pediatric Dentists", "Orthodontists", "General Dentistry", "Cosmetic Dentists", "Dentists"]},
  "KX_4sldJKgkEWaYVfSWjwQ": {"state": "ON", "address": "17830 Leslie Street", "review_count": 11, "stars": 3.5, "name": "Mint Garden", "city": "Newmarket", "categories": ["Restaurants", "Food", "Vietnamese"]},
  "e4-Clr5QT4l3Rf9R7tQ5aQ": {"state": "AZ", "address": "1209 E Bell Rd", "review_count": 25, "stars": 4.0, "name": "Fresh & Easy", "city": "Phoenix", "categories": ["Shopping", "Grocery", "Florists", "Flowers & Gifts", "Bakeries", "Convenience Stores", "Food"]},
  "He-G7vWjzVUysIKrfNbPUQ": {"state": "PA", "address": "3101 Washington Rd", "review_count": 11, "stars": 3.0, "name": "Stephen Szabo Salon", "city": "McMurray", "categories": ["Hair Stylists", "Hair Salons", "Men's Hair Salons", "Blow Dry/Out Services", "Hair Extensions", "Beauty & Spas"]},
  "5GAXZ7gJ81TSR0-Q6AMp_A": {"state": "ON", "address": "90 Edgeley Boulevard", "review_count": 7, "stars": 4.0, "name": "Via Panini", "city": "Vaughan", "categories": ["Italian", "Restaurants"]},
  "cehTmoCXPi0a3FwCE3Tq2Q": {"state": "NV", "address": "2370 E Serene Ave", "review_count": 6, "stars": 4.5, "name": "Red Wing Shoes", "city": "Las Vegas", "categories": ["Shopping", "Fashion", "Shoe Stores"]},
  "WghcqSAGCzKOhprLblYWVA": {"state": "NV", "address": "7980 W Sahara Ave", "review_count": 25, "stars": 5.0, "name": "Get Results Personal Training", "city": "Las Vegas", "categories": ["Active Life", "Boot Camps", "Trainers", "Fitness & Instruction", "Gyms"]},
  "fUOY7g6JcO0m3iZNfK0O0g": {"state": "ON", "address": "124 Atlantic Avenue", "review_count": 32, "stars": 3.0, "name": "Injapan", "city": "Toronto", "categories": ["Restaurants", "Japanese", "Sushi Bars"]},
  "-McKyjNSqS1h9dDJH3dyUA": {"state": "BW", "address": "Konrad-Adenauer-Str. 3", "review_count": 15, "stars": 3.5, "name": "Restaurant Plenum", "city": "Stuttgart", "categories": ["Restaurants", "Coffee & Tea", "Cafes", "German", "Food"]},
  "yh-NN-dCaxxleNcI-_bsUA": {"state": "OH", "address": "1331 S Water St", "review_count": 7, "stars": 2.5, "name": "El Dorado's", "city": "Kent", "categories": ["Pizza", "Restaurants"]},
  "oZBISmgb-GjOdj-ik8UfjA": {"state": "AZ", "address": "2840 N Dysart Rd", "review_count": 7, "stars": 1.5, "name": "Cvs Pharmacy", "city": "Goodyear", "categories": ["Shopping", "Drugstores"]},
  "Gu-xs3NIQTj3Mj2xYoN2aw": {"state": "ON", "address": "9665 Bayview Avenue, Unit 1-4", "review_count": 34, "stars": 3.5, "name": "Maxim Bakery & Restaurant", "city": "Richmond Hill", "categories": ["French", "Food", "Bakeries", "Restaurants"]},
  "LaWNGoxsBBrzm6C7Driz5Q": {"state": "PA", "address": "5241 Library Rd", "review_count": 4, "stars": 5.0, "name": "Shear Talent", "city": "Bethel Park", "categories": ["Hair Extensions", "Nail Salons", "Makeup Artists", "Hair Salons", "Permanent Makeup", "Beauty & Spas"]},
  "zdC6e26U7tS1XtWcJPKCcA": {"state": "NC", "address": "308 Concord Pkwy N", "review_count": 3, "stars": 3.0, "name": "Concord Parkway Animal Hospital", "city": "Concord", "categories": ["Pets", "Veterinarians"]},
  "9zSRAOUIM3I2ZnY9xwvioQ": {"state": "AZ", "address": "4959 W Ray Rd", "review_count": 10, "stars": 3.0, "name": "Sandstone Cafe", "city": "Chandler", "categories": ["Restaurants", "American (Traditional)"]},
  "fNMVV_ZX7CJSDWQGdOM8Nw": {"state": "NC", "address": "600 E 4th St", "review_count": 7, "stars": 3.5, "name": "Showmars Government Center", "city": "Charlotte", "categories": ["Restaurants", "American (Traditional)"]},
  "NFTh6mj3X2AnHJCKIFUk5Q": {"state": "NC", "address": "8540 E Independence Blvd", "review_count": 17, "stars": 4.0, "name": "Fairfield Inn & Suites", "city": "Charlotte", "categories": ["Hotels", "Event Planning & Services", "Hotels & Travel"]},
  "BiBILjVBFpT3QtYRwhrL6w": {"state": "OH", "address": "2080 Lee Rd", "review_count": 9, "stars": 4.0, "name": "Washington & Lee Service, Inc", "city": "Cleveland", "categories": ["Auto Repair", "Gas Stations", "Automotive"]},
  "AXb5gCwqHl-_v6ZIMb1mXQ": {"state": "PA", "address": "707 E Lancaster Ave", "review_count": 43, "stars": 3.0, "name": "Sheraton Great Valley Hotel", "city": "Frazer", "categories": ["Hotels", "Restaurants", "Event Planning & Services", "American (New)", "Hotels & Travel"]},
  "lZ18HyZhfrrN_VAJIpyhxQ": {"state": "ON", "address": "111 Jefferson Avenue", "review_count": 25, "stars": 3.0, "name": "X-Nail & Spa", "city": "Toronto", "categories": ["Hair Salons", "Beauty & Spas", "Nail Salons"]},
  "EJFdWX908N8Yc2XG0Lky8A": {"state": "PA", "address": "104 43rd St", "review_count": 5, "stars": 4.0, "name": "River Moon Cafe", "city": "Pittsburgh", "categories": ["Cafes", "Restaurants"]},
  "t8yi2l7pZF43Rlf9_lHdDA": {"state": "ON", "address": "79A Yonge Street", "review_count": 29, "stars": 2.5, "name": "Hero Certified Burgers - King & Yonge", "city": "Toronto", "categories": ["Burgers", "Restaurants"]},
  "TzlaonysPohYJyLIFTk6Jg": {"state": "AZ", "address": "10166 E Clinton St", "review_count": 3, "stars": 5.0, "name": "Az Vip Transportation", "city": "Scottsdale", "categories": ["Transportation", "Event Planning & Services", "Airlines", "Hotels & Travel", "Airport Shuttles", "Limos", "Party Bus Rentals", "Public Transportation"]},
  "AR6mrWO89rq-ku_t_E71AA": {"state": "WI", "address": "111 N Broom St", "review_count": 7, "stars": 3.5, "name": "Munchie Delivery", "city": "Madison", "categories": ["Convenience Stores", "Desserts", "Food Delivery Services", "Food", "Grocery"]},
  "P5TLch0Fu9p3o6W2hRSz0g": {"state": "NV", "address": "1785 E Sunset Rd", "review_count": 5, "stars": 4.5, "name": "Terrible Herbst", "city": "Las Vegas", "categories": ["Automotive", "Gas Stations"]},
  "dzHiixYF9f37QkMUa4zYZQ": {"state": "AZ", "address": "4440 N 36th St, Ste 240", "review_count": 23, "stars": 4.5, "name": "Endurance Rehabilitation", "city": "Phoenix", "categories": ["Yoga", "Health & Medical", "Active Life", "Fitness & Instruction", "Physical Therapy", "Trainers"]},
  "N_W4JlpCw02VPSf5Mrxwqg": {"state": "IL", "address": "607 E Green St", "review_count": 7, "stars": 4.0, "name": "Dunkin' Donuts", "city": "Champaign", "categories": ["Food", "Donuts", "Coffee & Tea"]},
  "DvF-xOyB_3oU-Sy0iLXz6A": {"state": "ON", "address": "12 Goldfinch Court, Unit 302", "review_count": 3, "stars": 3.5, "name": "Max Moving Corporation", "city": "Toronto", "categories": ["Movers", "Home Services"]},
  "d7AtQMYDUh40DeJinidFNQ": {"state": "QC", "address": "7387 Boulevard Saint-Michel", "review_count": 3, "stars": 3.5, "name": "2 Cochons", "city": "Montréal", "categories": ["Restaurants", "Sandwiches", "Delicatessen", "Asian Fusion", "Food", "Cafes"]},
  "sG3jr8wLMpncvwvu8JM1Dw": {"state": "QC", "address": "5776 Sherbrooke Rue W", "review_count": 3, "stars": 3.5, "name": "Jimi Music Store", "city": "Montréal", "categories": ["Musical Instruments & Teachers", "Shopping"]},
  "PEKloTo1IkW_gyxp15e8Dg": {"state": "ON", "address": "1219 Yonge Street", "review_count": 7, "stars": 3.5, "name": "Amy's Lash & Beauty Spa", "city": "Toronto", "categories": ["Eyelash Service", "Beauty & Spas"]},
  "GRNe0AktRPbZKRSVzo4dUw": {"state": "AZ", "address": "5450 E High St", "review_count": 11, "stars": 5.0, "name": "Inline Business Coach and Advisors", "city": "Phoenix", "categories": ["Professional Services"]},
  "5XejqzaFmtkZMstJS5Iy-w": {"state": "AZ", "address": "503 W Thomas Rd", "review_count": 37, "stars": 4.0, "name": "D'Lish Cafe", "city": "Phoenix", "categories": ["Vegan", "American (New)", "Restaurants", "Sandwiches", "Salad", "Wraps", "Food"]},
  "l5ijDMpYdyKbF0CxiCVO_Q": {"state": "NV", "address": "3400 Las Vegas Blvd", "review_count": 24, "stars": 4.0, "name": "Starlight Tattoo", "city": "Las Vegas", "categories": ["Beauty & Spas", "Piercing", "Tattoo"]},
  "0953KSZ26LmJ7CDacVzpYg": {"state": "NV", "address": "3430 E Tropicana Ave", "review_count": 3, "stars": 2.5, "name": "dd's DISCOUNTS", "city": "Las Vegas", "categories": ["Department Stores", "Home Decor", "Shopping", "Fashion", "Women's Clothing", "Discount Store", "Home & Garden", "Men's Clothing"]},
  "pOyt4Fon5n783Jc-hrSq-A": {"state": "WI", "address": "6313 McKee Rd", "review_count": 14, "stars": 4.5, "name": "Apple Wellness - Fitchburg Health Store", "city": "Fitchburg", "categories": ["Health Markets", "Food", "Beauty & Spas", "Specialty Food", "Shopping", "Cosmetics & Beauty Supply"]},
  "o8cX77mJ1nHMMo0URPS5bg": {"state": "AZ", "address": "1111 N Gilbert Rd, Unit 110", "review_count": 5, "stars": 4.0, "name": "Joey Smoke Shop", "city": "Gilbert", "categories": ["Tobacco Shops", "Hobby Shops", "Shopping"]},
  "NC03ZDFpIYpEi2aiFTmGPg": {"state": "NV", "address": "6115 W Tropicana Ave", "review_count": 6, "stars": 3.0, "name": "Office Depot", "city": "Las Vegas", "categories": ["Office Equipment", "Shopping"]},
  "1Jp_hmPNUZArNqzpbm7B0g": {"state": "NV", "address": "7260 Cimarron Rd, Ste 130", "review_count": 20, "stars": 4.5, "name": "Task Electric", "city": "Las Vegas", "categories": ["Home Services", "Lighting Fixtures & Equipment", "Local Services", "Electricians", "TV Mounting"]},
  "B5EZlEDH6AVDk8tQGHAGqg": {"state": "WI", "address": "2302 Packers Ave", "review_count": 34, "stars": 4.0, "name": "Villa Tap", "city": "Madison", "categories": ["American (Traditional)", "Nightlife", "Dive Bars", "Restaurants", "Bars"]},
  "r6Jw8oRCeumxu7Y1WRxT7A": {"state": "IL", "address": "", "review_count": 4, "stars": 5.0, "name": "D&D Cleaning", "city": "Urbana", "categories": ["Home Cleaning", "Home Services", "Window Washing"]},
  "0FMKDOU8TJT1x87OKYGDTg": {"state": "AZ", "address": "13375 W McDowell", "review_count": 65, "stars": 5.0, "name": "Senior's Barber Shop", "city": "Goodyear", "categories": ["Barbers", "Beauty & Spas"]},
  "XIeu6wabop6VabOVFNVHIg": {"state": "AZ", "address": "4232 W Van Buren St", "review_count": 5, "stars": 2.5, "name": "Michele's Cocktail Lounge", "city": "Phoenix", "categories": ["Nightlife"]},
  "Dj0S-Oe4ytRJzMGUPgYUkw": {"state": "OH", "address": "38295 Chestnut Ridge Rd", "review_count": 4, "stars": 2.0, "name": "Panera Bread", "city": "Elyria", "categories": ["Soup", "Salad", "Sandwiches", "Restaurants"]},
  "kyXEnWKQGWSThY6EcjORuw": {"state": "IL", "address": "627 E Green St", "review_count": 109, "stars": 4.0, "name": "Zorba's Restaurant", "city": "Champaign", "categories": ["Restaurants", "Greek", "Salad", "Mediterranean"]},
  "KVPGEIZb0i5EBYOrlMOziQ": {"state": "NV", "address": "420 Valle Verde Dr", "review_count": 9, "stars": 4.0, "name": "Foxridge Park", "city": "Henderson", "categories": ["Active Life", "Parks", "Playgrounds"]},
  "WfB_SsYeKy83QQsqAAyGVQ": {"state": "NV", "address": "5006 S Maryland Pkwy, Ste 17", "review_count": 5, "stars": 4.5, "name": "Cancun Bar & Grill", "city": "Las Vegas", "categories": ["Karaoke", "Bars", "Mexican", "Restaurants", "Nightlife", "Dance Clubs"]},
  "bOOgAB_CEWWsxalAthnRSw": {"state": "NV", "address": "3475 S Las Vegas Blvd", "review_count": 46, "stars": 4.5, "name": "Tenors of Rock", "city": "Las Vegas", "categories": ["Performing Arts", "Arts & Entertainment"]},
  "WZdHNL9F0VWPRGLf1GQcbA": {"state": "NC", "address": "2656 E Franklin Blvd", "review_count": 28, "stars": 2.5, "name": "Steak 'n Shake", "city": "Gastonia", "categories": ["Fast Food", "Restaurants", "Burgers", "Breakfast & Brunch", "American (New)"]},
  "vIAQV1_p48AsKP-B9iULwg": {"state": "OH", "address": "2932 Wooster Rd", "review_count": 6, "stars": 5.0, "name": "Europtical", "city": "Rocky River", "categories": ["Eyewear & Opticians", "Health & Medical", "Shopping", "Optometrists"]},
  "xZlWuKKUgETwFgZ0dshHAA": {"state": "NV", "address": "953 East Sahara, Ste B-30", "review_count": 3, "stars": 2.5, "name": "OMD Official Music District", "city": "Las Vegas", "categories": ["Music Venues", "Nightlife", "Arts & Entertainment"]},
  "x5s5yvoI3QFLBZE6JNNhyg": {"state": "AZ", "address": "", "review_count": 5, "stars": 5.0, "name": "Hard Surface Detox Pros", "city": "Peoria", "categories": ["Home Services", "Grout Services", "Carpet Cleaning", "Damage Restoration", "Home Cleaning", "Local Services"]},
  "kP9GA7pq8CBo9zLNu2ccAQ": {"state": "AZ", "address": "4328 E Chandler Blvd", "review_count": 3, "stars": 1.5, "name": "Valero - In The Zone", "city": "Phoenix", "categories": ["Automotive", "Gas Stations"]},
  "Qs7X8UTwtp9SvtxvEP4hLg": {"state": "PA", "address": "The Water Works, 974 Freeport Rd", "review_count": 7, "stars": 5.0, "name": "Fine Wine & Good Spirits - Premium Collection", "city": "Pittsburgh", "categories": ["Beer", "Wine & Spirits", "Food"]},
  "YZLtgv4rgOQcDL23fcRigQ": {"state": "AZ", "address": "6730 E Mcdowell Rd", "review_count": 3, "stars": 5.0, "name": "Simia Henry.com", "city": "Phoenix", "categories": ["Arts & Entertainment", "Health & Medical", "Supernatural Readings"]},
  "T5CdfrZWw-uW9Y5L_sddqQ": {"state": "PA", "address": "7235 Steubenville Pike", "review_count": 9, "stars": 3.0, "name": "Police Station Pizza", "city": "Oakdale", "categories": ["Pizza", "Restaurants"]},
  "6PwKC0dqP9uI85FEP86iPQ": {"state": "AZ", "address": "5221 S Power Rd, Ste 104", "review_count": 164, "stars": 3.5, "name": "Red Viet Cuisine - Sushi", "city": "MESA", "categories": ["Sushi Bars", "Restaurants", "Japanese", "Asian Fusion", "Vietnamese"]},
  "nbhBRhZtdaZmMMeb2i02pg": {"state": "ON", "address": "2777 Steeles Avenue W", "review_count": 3, "stars": 5.0, "name": "Sunnyside Grill", "city": "Toronto", "categories": ["Restaurants", "Breakfast & Brunch"]},
  "bXuHmdgo3DM7JIYNXN4Ndg": {"state": "AZ", "address": "23616 N 19th Ave", "review_count": 5, "stars": 4.5, "name": "Today's Patio", "city": "Phoenix", "categories": ["Home & Garden", "Active Life", "Home Decor", "Shopping", "Discount Store", "Furniture Stores", "Swimming Pools"]},
  "zF7HHlWxhgpaO4IVmaNeag": {"state": "AZ", "address": "One E Washington", "review_count": 5, "stars": 4.0, "name": "Check, Please Arizona Festival", "city": "Phoenix", "categories": ["Arts & Entertainment", "Yelp Events", "Festivals", "Local Flavor"]},
  "d2HSFutxpaYsCPglJPRe1Q": {"state": "NV", "address": "4700 Meadows Ln", "review_count": 13, "stars": 4.0, "name": "Winchell's Donut House", "city": "Las Vegas", "categories": ["Food", "Donuts"]},
  "rasO0zMTS6uw-LX9IFbfSw": {"state": "AZ", "address": "284 East Chilton Dr, Ste 1", "review_count": 22, "stars": 3.5, "name": "ABC Plumbing and Rooter", "city": "Chandler", "categories": ["Local Services", "Home Services", "Plumbing", "Septic Services", "Water Heater Installation/Repair"]},
  "gIVjdDWRnS1yDVpPF3oUeg": {"state": "ON", "address": "7665 Kennedy Road", "review_count": 8, "stars": 4.0, "name": "Pizza Pizza", "city": "Markham", "categories": ["Italian", "Chicken Wings", "Fast Food", "Restaurants", "Pizza"]},
  "U1ZVgF-kfkvv_rcoe0RglQ": {"state": "AZ", "address": "3417 N 7th Ave", "review_count": 172, "stars": 4.5, "name": "Pho Noodles", "city": "Phoenix", "categories": ["Restaurants", "Noodles", "Vietnamese"]},
  "bBZwjf9jAe6j-n54jDcTxA": {"state": "AZ", "address": "4250 W Anthem Way, Ste 430", "review_count": 4, "stars": 2.0, "name": "Century 21 Desert Estates Realty", "city": "Anthem", "categories": ["Real Estate Services", "Real Estate", "Home Services", "Property Management", "Real Estate Agents"]},
  "uZd7UVMib1EYUFFbfWkGdw": {"state": "NV", "address": "US Rt 93", "review_count": 3, "stars": 4.5, "name": "Red and Black Mountain", "city": "Boulder City", "categories": ["Hiking", "Active Life"]},
  "Pd52CjgyEU3Rb8co6QfTPw": {"state": "NV", "address": "6730 S Las Vegas Blvd", "review_count": 13, "stars": 4.0, "name": "Flight Deck Bar & Grill", "city": "Las Vegas", "categories": ["Nightlife", "Bars", "Barbeque", "Sports Bars", "American (New)", "Restaurants"]},
  "tdnvRIGCVSwWx5A-Xh15-Q": {"state": "NV", "address": "The Venetian Hotel & Casino, 3355 Las Vegas Blvd S", "review_count": 25, "stars": 4.0, "name": "Wayne Brady - Making %@it Up", "city": "Las Vegas", "categories": ["Performing Arts", "Arts & Entertainment"]},
  "3b4efqz06QrLQ_w2xLc4pA": {"state": "AZ", "address": "10223 N Metro Parkway E", "review_count": 40, "stars": 3.0, "name": "Olive Garden Italian Restaurant", "city": "Phoenix", "categories": ["Restaurants", "Italian"]},
  "8y56fOiKhtCnqaiYB2S2Qg": {"state": "OH", "address": "96 S Main St", "review_count": 4, "stars": 4.0, "name": "Brewster's Pub", "city": "Munroe Falls", "categories": ["Nightlife", "Pubs", "Bars"]},
  "Svs-B-a5-13D2dGTKxLsyw": {"state": "OH", "address": "11680 Snow Rd", "review_count": 4, "stars": 3.0, "name": "Mr Chicken", "city": "Cleveland", "categories": ["Restaurants", "Fast Food"]},
  "WSZL9uQ9JMOrrulMKEl7Tw": {"state": "ON", "address": "2210 Markham Road, Unit 3", "review_count": 32, "stars": 4.5, "name": "Mayze", "city": "Toronto", "categories": ["Arcades", "Arts & Entertainment", "Party & Event Planning", "Escape Games", "Event Planning & Services", "Active Life"]},
  "2v-8QQfMLX2PCz-0S6gISQ": {"state": "AZ", "address": "3441 W Northern Ave", "review_count": 7, "stars": 2.5, "name": "Papa John's Pizza", "city": "Phoenix", "categories": ["Pizza", "Restaurants", "Fast Food"]},
  "F31RycVVooeIOp9jsXmg6g": {"state": "MLN", "address": "5 Canonmills", "review_count": 16, "stars": 4.5, "name": "The Bluebird Cafe", "city": "Edinburgh", "categories": ["Breakfast & Brunch", "Diners", "Restaurants", "Cafes", "British"]},
  "c_XbaJqhm-5ycSBOkVUBmg": {"state": "QC", "address": "1855 Rue Saint Catherine Ouest, H3H 1M2", "review_count": 33, "stars": 3.5, "name": "Don Taco", "city": "Montreal", "categories": ["Restaurants", "Mexican"]},
  "i-2HewuIRF2ORDT8UfrSUw": {"state": "AZ", "address": "16413 N 91st St, Ste C150", "review_count": 52, "stars": 4.0, "name": "Collins Commercial Services", "city": "Scottsdale", "categories": ["Heating & Air Conditioning/HVAC", "Plumbing", "Home Services"]},
  "wZ-o2o-LVjc03JKb9_oZuQ": {"state": "NV", "address": "1335 E Sunset Rd, Ste D", "review_count": 13, "stars": 4.0, "name": "Vegas Bead Shoppe", "city": "Las Vegas", "categories": ["Jewelry", "Arts & Crafts", "Shopping"]},
  "btRo30YqzXeTbgxk6gnLMw": {"state": "OH", "address": "380 Dover Center Rd", "review_count": 3, "stars": 1.5, "name": "Pizza Hut", "city": "Bay Village", "categories": ["Pizza", "Italian", "Chicken Wings", "Restaurants"]},
  "-nHkhiuerqmfBG3v2v9O-g": {"state": "PA", "address": "5217 Clairton Blvd", "review_count": 5, "stars": 2.5, "name": "Bruegger's Bagels", "city": "Pittsburgh", "categories": ["Breakfast & Brunch", "Bagels", "Restaurants", "Bakeries", "Sandwiches", "Food"]},
  "MmR06_kNAbmOPK-0pKvGtA": {"state": "NV", "address": "4300 Meadows Ln", "review_count": 3, "stars": 4.0, "name": "Cinnabon", "city": "Las Vegas", "categories": ["Food", "Coffee & Tea", "Desserts"]},
  "Uy3_5nLo3sYkAuSX6mjdmg": {"state": "NV", "address": "8560 Las Vegas Blvd S", "review_count": 33, "stars": 4.5, "name": "Geebee's Bar & Grill", "city": "Las Vegas", "categories": ["Restaurants", "American (Traditional)"]},
  "lXGx_aKtF_UxenWDDkogWg": {"state": "ON", "address": "756 St Clair Avenue W", "review_count": 6, "stars": 4.0, "name": "Northern Karate School", "city": "Toronto", "categories": ["Active Life", "Sporting Goods", "Karate", "Education", "Shopping", "Martial Arts", "Specialty Schools", "Trainers", "Fitness & Instruction"]},
  "1cLXGXThDYZ5WK_KpBLtkw": {"state": "OH", "address": "3710 Payne Ave", "review_count": 167, "stars": 4.0, "name": "Koko Bakery", "city": "Cleveland", "categories": ["Bakeries", "Coffee & Tea", "Bubble Tea", "Food"]},
  "bA4uXceTHDywJtTXQU7SkA": {"state": "NV", "address": "4670 Vandenberg Dr", "review_count": 3, "stars": 3.5, "name": "G&K Services", "city": "North Las Vegas", "categories": ["Fashion", "Clothing Rental", "Uniforms", "Building Supplies", "Home Services", "Shopping"]},
  "dfeT_kmoO388KzyVv0Styg": {"state": "ON", "address": "1500 Elgin Mills Road E, Unit 106", "review_count": 5, "stars": 4.0, "name": "Tutti Frutti", "city": "Richmond Hill", "categories": ["Food", "Ice Cream & Frozen Yogurt"]},
  "W1Yr6c2XDx_RBjb6WsV-aQ": {"state": "NV", "address": "333 S Valley View Blvd", "review_count": 140, "stars": 4.0, "name": "Divine Cafe at the Springs Preserve", "city": "Las Vegas", "categories": ["Restaurants", "Cafes", "American (New)", "Bars", "Nightlife", "Wine Bars"]},
  "8GL63JMAiD0mI-Z1Y-kT2Q": {"state": "OH", "address": "1501 Euclid Ave, Ste 200, Playhouse Square", "review_count": 5, "stars": 4.5, "name": "State Theater", "city": "Cleveland", "categories": ["Arts & Entertainment", "Performing Arts"]},
  "zWb-kwaANIPMS_AFBbVOew": {"state": "WI", "address": "32 W Towne Mall", "review_count": 8, "stars": 2.0, "name": "Banana Republic", "city": "Madison", "categories": ["Men's Clothing", "Women's Clothing", "Fashion", "Shopping"]},
  "_F3AMoo_zdl-he384ISQbw": {"state": "NV", "address": "3700 W Flamingo Rd", "review_count": 213, "stars": 4.0, "name": "Rock of Ages", "city": "Las Vegas", "categories": ["Arts & Entertainment", "Performing Arts"]},
  "mFE7N0p3f_7vcMTUy76ifw": {"state": "AZ", "address": "2780 E Germann Rd", "review_count": 49, "stars": 3.5, "name": "Village Inn", "city": "Chandler", "categories": ["American (Traditional)", "Breakfast & Brunch", "Salad", "Burgers", "Restaurants"]},
  "aLM-0HupwCE5r7bMIcQ2TQ": {"state": "NC", "address": "", "review_count": 3, "stars": 5.0, "name": "Septic Pumping Service", "city": "Matthews", "categories": ["Septic Services", "Home Services", "Plumbing", "Local Services"]},
  "JtBJ-UPbVjJvqzqkO-jnjA": {"state": "NC", "address": "11025 Carolina Place Pkwy", "review_count": 3, "stars": 2.0, "name": "Champ's Sports", "city": "Pineville", "categories": ["Shopping", "Sporting Goods"]},
  "zjySmTfL9WiMDVgp8-Jp3w": {"state": "NC", "address": "610 Jetton St, Ste 130", "review_count": 3, "stars": 3.5, "name": "TCBY", "city": "Davidson", "categories": ["Desserts", "Ice Cream & Frozen Yogurt", "Food"]},
  "wpWG_idUVCaMFl8C-H7BSQ": {"state": "AZ", "address": "7558 W Thunderbird Rd, Ste 1", "review_count": 19, "stars": 3.5, "name": "The UPS Store", "city": "Peoria", "categories": ["Notaries", "Printing Services", "Shipping Centers", "Local Services"]},
  "AZUCA3oiGou2wLnAYG1P6g": {"state": "AZ", "address": "2030 S Rural Rd", "review_count": 3, "stars": 2.5, "name": "Emergency Chiropractic", "city": "Tempe", "categories": ["Health & Medical", "Chiropractors"]},
  "BnuzcebyB1AfxH0kjNWqSg": {"state": "PA", "address": "245 Lancaster Ave", "review_count": 25, "stars": 3.5, "name": "Carrabba's Italian Grill", "city": "Frazer", "categories": ["Restaurants", "Italian", "Seafood"]},
  "m0FNdHLRkgKL1aVOQrfzUA": {"state": "ON", "address": "748 Mount Pleasant Road", "review_count": 3, "stars": 3.5, "name": "Perfect Cleaners", "city": "Toronto", "categories": ["Local Services", "Dry Cleaning & Laundry", "Laundry Services"]},
  "irYAkavSVtIEyGOsHK-yPw": {"state": "AZ", "address": "1625 N Central Ave", "review_count": 43, "stars": 3.5, "name": "Palette", "city": "Phoenix", "categories": ["Event Planning & Services", "American (New)", "Sandwiches", "Salad", "Caterers", "Restaurants"]},
  "llE7OE0-4_LTS8rpGKOO-Q": {"state": "NC", "address": "2609 N Duke St, Ste 618", "review_count": 5, "stars": 4.5, "name": "University Dental Associates", "city": "Charlotte", "categories": ["Cosmetic Dentists", "Dentists", "Orthodontists", "Health & Medical", "General Dentistry"]},
  "strJsTvTHqWS18GVJQEHoA": {"state": "NV", "address": "1710 W Horizon Ridge Pkwy, Ste 110", "review_count": 22, "stars": 5.0, "name": "Synergy Physical Therapy", "city": "Henderson", "categories": ["Weight Loss Centers", "Physical Therapy", "Health & Medical"]},
  "cYuGJKCCazgCnsGGlBxaEQ": {"state": "AZ", "address": "1623 N Granite Reef Rd", "review_count": 8, "stars": 4.5, "name": "Bennie's Back Alley Barber Shop", "city": "Scottsdale", "categories": ["Blow Dry/Out Services", "Hair Salons", "Barbers", "Hair Stylists", "Beauty & Spas"]},
  "JmKgz6n7zn24F-WkgT-kiA": {"state": "ON", "address": "7 King Street E", "review_count": 7, "stars": 4.5, "name": "Maki My Way", "city": "Toronto", "categories": ["Restaurants", "Sushi Bars", "Japanese", "Asian Fusion"]},
  "nJ3mXjItS8WcwhYbzbfDQw": {"state": "NC", "address": "5110 Park Rd, Ste 2F", "review_count": 5, "stars": 4.0, "name": "Scott's Karat Patch", "city": "Charlotte", "categories": ["Watch Repair", "Jewelry Repair", "Shopping", "Local Services", "Jewelry"]},
  "bLva9YGmDcnar3YKHE2XzA": {"state": "PA", "address": "5874 Forbes Ave", "review_count": 31, "stars": 3.5, "name": "Tutti Frutti Frozen Yogurt", "city": "Pittsburgh", "categories": ["Food", "Ice Cream & Frozen Yogurt"]},
  "lBNPDcSvmUbq7W69HvmRTA": {"state": "PA", "address": "550 Butler St", "review_count": 15, "stars": 1.5, "name": "Pizza Hut", "city": "Etna", "categories": ["Italian", "Pizza", "Chicken Wings", "Restaurants"]},
  "dTWfATVrBfKj7Vdn0qWVWg": {"state": "ON", "address": "8 Glen Watford Drive", "review_count": 6, "stars": 3.0, "name": "Flavor Cuisine", "city": "Toronto", "categories": ["Restaurants", "Chinese", "Food Court"]},
  "e3rNvRnupvSMu6BABlDUuQ": {"state": "NV", "address": "1450 W Horizon Ridge Pkwy, Ste 425", "review_count": 68, "stars": 5.0, "name": "Henderson Pet Resort", "city": "Henderson", "categories": ["Pet Groomers", "Pet Sitting", "Pets", "Pet Services", "Pet Training"]},
  "8XQmnE-v6RrsHiqEz6QXdg": {"state": "OH", "address": "9294 Mentor Ave", "review_count": 4, "stars": 3.5, "name": "Havel's Flowers & Greenhouses", "city": "Mentor", "categories": ["Florists", "Wholesale Stores", "Shopping", "Flowers & Gifts"]},
  "-ooEO2YqDQVYNHnSF2BPfw": {"state": "QC", "address": "12 Rue Dante", "review_count": 11, "stars": 4.5, "name": "Restaurant Lucca", "city": "Montréal", "categories": ["Italian", "Restaurants"]},
  "aFBCmJUYrPeol_P75QX7Jw": {"state": "ON", "address": "10 Vogell Road", "review_count": 88, "stars": 3.0, "name": "Fraticelli's Authentic Italian Grill", "city": "Richmond Hill", "categories": ["Restaurants", "Italian"]},
  "DCQ3qzzmsm1JZxvW8-bCgQ": {"state": "AZ", "address": "3552 E Corona Ave", "review_count": 12, "stars": 5.0, "name": "Phone Savers", "city": "Phoenix", "categories": ["Mobile Phones", "IT Services & Computer Repair", "Shopping", "Electronics Repair", "Mobile Phone Repair", "Local Services"]},
  "W58P-gdejuMMh2r7OHpIyQ": {"state": "AZ", "address": "40TH St E Indian School Rd", "review_count": 7, "stars": 5.0, "name": "Essence of Harmony Sacred Massage", "city": "Phoenix", "categories": ["Education", "Health & Medical", "Beauty & Spas", "Massage", "Physical Therapy", "Massage Therapy"]},
  "AuE8ETTblOgY1CL3c9Up2g": {"state": "WI", "address": "275 Davison Dr", "review_count": 4, "stars": 2.0, "name": "Walgreens", "city": "Sun Prairie", "categories": ["Drugstores", "Food", "Beauty & Spas", "Convenience Stores", "Cosmetics & Beauty Supply", "Shopping"]},
  "S4a42azhoOmr0fpeNkggHg": {"state": "NC", "address": "11812 Carolina Place Pkwy, Ste C", "review_count": 3, "stars": 2.5, "name": "By Design", "city": "Pineville", "categories": ["Home & Garden", "Furniture Stores", "Shopping"]},
  "c1HfT-Rm4iYSxsAsk8eW4Q": {"state": "OH", "address": "", "review_count": 5, "stars": 5.0, "name": "Cleveland Dog Walk", "city": "Cleveland", "categories": ["Pet Services", "Pet Sitting", "Dog Walkers", "Pets"]},
  "spDZkD6cp0JUUm6ghIWHzA": {"state": "ON", "address": "8515 McCowan Road", "review_count": 80, "stars": 3.0, "name": "Kitchen M", "city": "Markham", "categories": ["Restaurants", "Chinese"]},
  "JdzoBklGL66IPFxGkJ2lQA": {"state": "ON", "address": "Pantages Hotel, 200 Victoria Street", "review_count": 4, "stars": 3.5, "name": "Shizen Spa", "city": "Toronto", "categories": ["Massage", "Nail Salons", "Skin Care", "Day Spas", "Beauty & Spas"]},
  "veXxt8rGY_RJPpA5QkHT9Q": {"state": "OH", "address": "2466 Fairmount Blvd", "review_count": 97, "stars": 3.5, "name": "Barrio", "city": "Cleveland Heights", "categories": ["Food", "Restaurants", "Tacos", "Food Trucks", "Mexican"]},
  "QkG3KUXwqZBW18A9k1xqCA": {"state": "AZ", "address": "2810 North 75th Ave", "review_count": 37, "stars": 2.5, "name": "Red Lobster", "city": "Phoenix", "categories": ["American (Traditional)", "Restaurants", "Seafood"]},
  "iOudjMD1sFvD9QTltPQiTg": {"state": "OH", "address": "35110 Maplegrove Rd", "review_count": 15, "stars": 2.5, "name": "Motel 6 Cleveland-Willoughby", "city": "Willoughby", "categories": ["Hotels & Travel", "Event Planning & Services", "Hotels"]},
  "Pp_ca_wyn1vsKBNR94ZRXw": {"state": "AZ", "address": "4205 W Anthem Way, Ste 108", "review_count": 6, "stars": 2.5, "name": "Anthem Smoke & Vape Shop", "city": "Phoenix", "categories": ["Tobacco Shops", "Shopping", "Vape Shops"]},
  "M5jiUpAuliJtCYOF0cI3wA": {"state": "AZ", "address": "11790 N 91st Ave", "review_count": 30, "stars": 4.5, "name": "S & S Tire & Auto Service Center", "city": "Peoria", "categories": ["Automotive", "Tires", "Auto Repair", "Auto Parts & Supplies", "Oil Change Stations"]},
  "aWnASLfWj1G6ptH4SR5RRA": {"state": "NV", "address": "9795 W Charleston Blvd, Ste 101", "review_count": 3, "stars": 2.0, "name": "Rocky Mountain Chocolate Factory", "city": "Las Vegas", "categories": ["Chocolatiers & Shops", "Desserts", "Specialty Food", "Food"]},
  "FXHfcFVEfI1vVngW2gVOpw": {"state": "ON", "address": "201 Harbord Street", "review_count": 55, "stars": 4.0, "name": "Bampot House of Tea & Board Games", "city": "Toronto", "categories": ["Coffee & Tea", "Restaurants", "Food", "Mediterranean", "Tea Rooms"]},
  "aD4qhONCE5catMdQC4sqwg": {"state": "ON", "address": "3331 Danforth Avenue", "review_count": 10, "stars": 3.5, "name": "Reginos Pizza", "city": "Scarborough", "categories": ["Restaurants", "Pizza"]},
  "o9eMRCWt5PkpLDE0gOPtcQ": {"state": "BW", "address": "Richterstr. 11", "review_count": 5, "stars": 4.0, "name": "Messina", "city": "Stuttgart", "categories": ["Italian", "Restaurants"]},
  "HCIr-4BvlO-SvEPMka9xpQ": {"state": "AZ", "address": "8643 W Kelton Ln, Ste 110", "review_count": 7, "stars": 3.5, "name": "Oasis Gymnastics & Sports Center", "city": "Peoria", "categories": ["Gymnastics", "Dance Schools", "Performing Arts", "Arts & Entertainment", "Martial Arts", "Summer Camps", "Fitness & Instruction", "Gyms", "Specialty Schools", "Active Life", "Education"]},
  "O_UC_izJXcAmkm6HlEyGSA": {"state": "ON", "address": "111 Dupont Street", "review_count": 363, "stars": 4.0, "name": "Playa Cabana", "city": "Toronto", "categories": ["Mexican", "Restaurants", "Nightlife", "Bars"]},
  "Muk-jU2W2x1D__h0pCXhbw": {"state": "ON", "address": "85 Hanna Ave, Ste 200", "review_count": 33, "stars": 3.5, "name": "GoodLife Fitness", "city": "Toronto", "categories": ["Active Life", "Sports Clubs", "Gyms", "Fitness & Instruction", "Trainers"]},
  "CfEJGhzBFkWKoe-UTT2jiw": {"state": "OH", "address": "4961 Dover Center Rd", "review_count": 12, "stars": 4.0, "name": "Exotic Nails Touch", "city": "North Olmsted", "categories": ["Beauty & Spas", "Nail Salons"]},
  "PfOCPjBrlQAnz__NXj9h_w": {"state": "OH", "address": "581 Howe Ave", "review_count": 116, "stars": 3.5, "name": "Brick House Tavern + Tap", "city": "Cuyahoga Falls", "categories": ["American (New)", "Nightlife", "Bars", "Sandwiches", "American (Traditional)", "Burgers", "Restaurants"]},
  "aYQoCA8Tn-khyTptMN_Uqw": {"state": "ON", "address": "7600 Weston Road, Unit 55", "review_count": 3, "stars": 2.5, "name": "Wellmedica Walk-in Medical Clinic", "city": "Vaughan", "categories": ["Medical Centers", "Cannabis Clinics", "Pharmacy", "Health & Medical", "Walk-in Clinics"]},
  "ORUUPE_Ahrcop9K7h6rvVQ": {"state": "OH", "address": "20 W Steels Corners Rd", "review_count": 3, "stars": 5.0, "name": "Falls Auto Body", "city": "Cuyahoga Falls", "categories": ["Automotive", "Body Shops", "Auto Glass Services"]},
  "pEMoLmRkS2dyIm_KpIr4hg": {"state": "OH", "address": "8514 Carnegie Ave", "review_count": 3, "stars": 5.0, "name": "Ben's Auto Body Specialists", "city": "Cleveland", "categories": ["Body Shops", "Automotive"]},
  "DVaTciFGcCXLHTufHZM4_A": {"state": "AZ", "address": "501 S Mill Ave, Ste B-101", "review_count": 161, "stars": 4.0, "name": "Big Bang - Dueling Piano Bar", "city": "Tempe", "categories": ["Music Venues", "Lounges", "Dive Bars", "Bars", "Nightlife", "Piano Bars", "Arts & Entertainment"]},
  "Po2W_ZiJdxItHHll4WP5WA": {"state": "FIF", "address": "Kingseat Road, Halbeath", "review_count": 3, "stars": 3.5, "name": "Thomsons World Of Furniture", "city": "Dunfermline", "categories": ["Shopping", "Home & Garden", "Furniture Stores"]},
  "GsvsUBgE-aYIeiCAenN1gA": {"state": "AZ", "address": "201 E Jefferson St", "review_count": 5, "stars": 4.5, "name": "Phoenix Tequila Festival", "city": "Phoenix", "categories": ["Local Flavor", "Festivals", "Arts & Entertainment"]},
  "AtdXq_gu9NTE5rx4ct_dGg": {"state": "ON", "address": "10 Dundas Street E", "review_count": 6, "stars": 4.0, "name": "DAVIDsTEA", "city": "Toronto", "categories": ["Coffee & Tea", "Food", "Tea Rooms"]},
  "Qv0OEziLJwyAqcgtrTsA4w": {"state": "AZ", "address": "15223 N Northsight Blvd", "review_count": 50, "stars": 3.5, "name": "Luke's Of Chicago", "city": "Scottsdale", "categories": ["Italian", "Restaurants", "Sandwiches", "Hot Dogs"]},
  "UuxH5yQpl73XJkzfLN-qdg": {"state": "OH", "address": "2401 Ontario St", "review_count": 36, "stars": 4.0, "name": "Cleveland Indians", "city": "Cleveland", "categories": ["Stadiums & Arenas", "Arts & Entertainment", "Professional Sports Teams"]},
  "DAG8irsIf0hMsEgDbrOE_A": {"state": "NV", "address": "3430 E Tropicana Ave", "review_count": 5, "stars": 5.0, "name": "Layla's Palace", "city": "Las Vegas", "categories": ["Wedding Planning", "Venues & Event Spaces", "Shopping", "Bridal", "Event Planning & Services"]},
  "d4GBb0eVWVdfL5aJx3UCRg": {"state": "SC", "address": "Tega Cay Golf Club, 15083 Molokai Dr", "review_count": 23, "stars": 3.5, "name": "Casual Water", "city": "Tega Cay", "categories": ["Arts & Entertainment", "American (Traditional)", "Sushi Bars", "Nightlife", "Restaurants", "Music Venues"]},
  "P2V7MzTHkC6-A0IlJIPBEw": {"state": "AZ", "address": "12416 N 28th Dr, Ste 16", "review_count": 41, "stars": 4.0, "name": "Spay Neuter Clinic: North Phoenix", "city": "Phoenix", "categories": ["Pets", "Veterinarians", "Pet Services"]},
  "NVaM_cKKJT3WWyP21PANzw": {"state": "AZ", "address": "1212 N Center St", "review_count": 3, "stars": 4.5, "name": "City of Mesa Cemetary", "city": "Mesa", "categories": ["Religious Organizations"]},
  "ykJM7EuGziATZ5u2qIT08g": {"state": "NC", "address": "1225 S Church St, Ste B", "review_count": 4, "stars": 5.0, "name": "My Fitness World", "city": "Charlotte", "categories": ["Active Life", "Fitness & Instruction", "Gyms"]},
  "XOSRcvtaKc_Q5H1SAzN20A": {"state": "PA", "address": "737 West Pike St", "review_count": 3, "stars": 4.5, "name": "East Coast Coffee", "city": "Houston", "categories": ["Breakfast & Brunch", "Gluten-Free", "Coffee & Tea", "Food", "Restaurants", "Sandwiches"]},
  "75MOveOQwQYbKR02rULdHA": {"state": "QC", "address": "4354 Wellington", "review_count": 5, "stars": 3.5, "name": "Restaurant de Wang Ji", "city": "Verdun", "categories": ["Restaurants", "Chinese"]},
  "bviMnO3CdmFE1btUGlXc-w": {"state": "ON", "address": "221 Augusta Avenue", "review_count": 4, "stars": 4.0, "name": "Green Post", "city": "Toronto", "categories": ["Food", "Specialty Food", "Health Markets"]},
  "BWhspaDdGQwZAkXieytvUQ": {"state": "NV", "address": "", "review_count": 11, "stars": 5.0, "name": "Gina Louisa Designs", "city": "Las Vegas", "categories": ["Flowers & Gifts", "Shopping", "Florists"]},
  "c7X2SdKxVJMaOnFROO8WEg": {"state": "NC", "address": "2838 The Plz", "review_count": 21, "stars": 4.5, "name": "Finga Lickin' Caribbean Eatery", "city": "Charlotte", "categories": ["Pizza", "Food", "Internet Cafes", "Restaurants", "Caribbean"]},
  "dA7KJReGl9PMi3Tg_mBHuw": {"state": "AZ", "address": "", "review_count": 3, "stars": 5.0, "name": "Poty Group", "city": "Mesa", "categories": ["Real Estate Agents", "Home Services", "Real Estate"]},
  "MfI-S7392ENwqWG89g4Opw": {"state": "AZ", "address": "2316 N 32nd St", "review_count": 4, "stars": 5.0, "name": "Southwest Drivetrain & 4WD", "city": "Phoenix", "categories": ["Automotive", "Auto Parts & Supplies"]},
  "w5WBrukfSuEyTjYUYlV4Ug": {"state": "OH", "address": "1 I-X Center Dr", "review_count": 16, "stars": 4.0, "name": "International Exposition Center", "city": "Cleveland", "categories": ["Venues & Event Spaces", "Event Planning & Services"]},
  "I5T7rAAENTTMHJtjGqB2-w": {"state": "ON", "address": "570 Bloor St W", "review_count": 8, "stars": 3.5, "name": "Rovers Pub", "city": "Toronto", "categories": ["Pubs", "Nightlife", "Bars"]},
  "1nhf9BPXOBFBkbRkpsFaxA": {"state": "ON", "address": "117 Eglinton Avenue E", "review_count": 6, "stars": 2.0, "name": "Mirage Grill & Lounge", "city": "Toronto", "categories": ["Breakfast & Brunch", "Food", "Coffee & Tea", "Canadian (New)", "Restaurants"]},
  "y0YoEY7JamQjTWju6OqjkQ": {"state": "AZ", "address": "3131 N 35th Ave, Ste O", "review_count": 10, "stars": 4.5, "name": "Bentley Carpet Installation and Sales", "city": "Phoenix", "categories": ["Flooring", "Carpeting", "Carpet Installation", "Home Services"]},
  "AVtMhvR_3bhL9VkRrAG6dQ": {"state": "AZ", "address": "11360 E Stradling Ave", "review_count": 3, "stars": 4.5, "name": "Accurate Pest Control", "city": "Mesa", "categories": ["Pest Control", "Local Services"]},
  "oB5KH-jYU93w-QnHas6EMA": {"state": "NV", "address": "101 S Rainbow Blvd, Ste 18", "review_count": 19, "stars": 4.0, "name": "Aces High Tobacco & Gifts", "city": "Las Vegas", "categories": ["Art Galleries", "Arts & Entertainment", "Head Shops", "Tobacco Shops", "Shopping"]},
  "8DShNS-LuFqpEWIp0HxijA": {"state": "AZ", "address": "5000 Arizona Mills Cr, Ste 435", "review_count": 9, "stars": 3.0, "name": "Sports Authority", "city": "Tempe", "categories": ["Sporting Goods", "Shopping"]},
  "2eU7ltXoQ2U7SyLhuY9Vxw": {"state": "ON", "address": "739 Ossington Avenue", "review_count": 9, "stars": 3.5, "name": "Fueled Espresso and Freshbar", "city": "Toronto", "categories": ["Juice Bars & Smoothies", "Food"]},
  "swZaqSjwq4UF8QhEtacx5A": {"state": "NV", "address": "1421 E Sunset Rd, Ste 10", "review_count": 5, "stars": 5.0, "name": "EasyStreet Realty", "city": "Las Vegas", "categories": ["Real Estate Services", "Real Estate", "Home Services"]},
  "JsQ_hJoHzEcXp209LI1t_g": {"state": "ON", "address": "292 Dupont Street", "review_count": 10, "stars": 3.5, "name": "Shoppers Drug Mart", "city": "Toronto", "categories": ["Photography Stores & Services", "Shopping", "Beauty & Spas", "Cosmetics & Beauty Supply", "Drugstores"]},
  "J-0_mtG3QyZ_7pBMoZBkfQ": {"state": "OH", "address": "3037 Som Center Rd", "review_count": 16, "stars": 4.0, "name": "North Chagrin Nature Center-Cleveland Metroparks", "city": "Willoughby Hills", "categories": ["Amusement Parks", "Parks", "Active Life"]},
  "1_3nOM7s9WqnJWTNu2-i8Q": {"state": "QC", "address": "305 Rue Sainte-Catherine O", "review_count": 8, "stars": 3.0, "name": "Le Bistro Balmoral", "city": "Montreal", "categories": ["Arts & Entertainment", "Festivals", "Restaurants", "French", "Gastropubs"]},
  "bA21m-qbgN_GNR6g-AlfYw": {"state": "NC", "address": "2932 E Franklin Blvd", "review_count": 30, "stars": 3.5, "name": "Dynasty Buffett", "city": "Gastonia", "categories": ["Restaurants", "Chinese"]},
  "kpM-NegY__31O-XMEEesdg": {"state": "OH", "address": "200 Market St", "review_count": 4, "stars": 3.0, "name": "Banana Republic", "city": "Westlake", "categories": ["Shopping", "Sporting Goods", "Women's Clothing", "Men's Clothing", "Sports Wear", "Fashion"]},
  "7m9ux0KgTe2NwUU0XA_9xQ": {"state": "PA", "address": "3030 Banksville Rd", "review_count": 14, "stars": 4.5, "name": "Double Take Auto Detailing", "city": "Pittsburgh", "categories": ["Automotive", "Auto Detailing", "Mobile Dent Repair", "Auto Upholstery", "Auto Glass Services"]},
  "9xq1pZfhkr8frt5O_EUW0w": {"state": "ON", "address": "1150 Queen St W", "review_count": 27, "stars": 4.0, "name": "The Drake Underground", "city": "Toronto", "categories": ["Dance Clubs", "Arts & Entertainment", "Music Venues", "Nightlife", "Lounges", "Bars"]},
  "l09JfMeQ6ynYs5MCJtrcmQ": {"state": "ON", "address": "2459 Yonge St", "review_count": 12, "stars": 3.0, "name": "Alize Catering", "city": "Toronto", "categories": ["Italian", "French", "Restaurants"]},
  "HcEJ2YiSLX_mT3RE0hvKWQ": {"state": "PA", "address": "135 9th St", "review_count": 21, "stars": 3.0, "name": "Blush", "city": "Pittsburgh", "categories": ["Nightlife", "Adult Entertainment", "Strip Clubs"]},
  "V75NLjJ8YokBD-lM2p_5Rw": {"state": "QC", "address": "3700 Street Patrick, Suit 111C", "review_count": 3, "stars": 5.0, "name": "Angry Monkey MMA", "city": "Montréal", "categories": ["Martial Arts", "Fitness & Instruction", "Boxing", "Gyms", "Active Life", "Trainers"]},
  "akRtfcCezswizRIaAqJ4fQ": {"state": "OH", "address": "25467 Detroit Avenue", "review_count": 9, "stars": 2.0, "name": "KFC", "city": "Westlake", "categories": ["Chicken Wings", "Restaurants", "Fast Food"]},
  "LL01hTt_eVdp-ws4zMDsrw": {"state": "ON", "address": "Toronto-Dominion Centre Bank Tower, 66 Wellington St W, Ste 2709", "review_count": 3, "stars": 5.0, "name": "Pil Son", "city": "Toronto", "categories": ["Health & Medical", "General Dentistry", "Dentists"]},
  "UlI0TksGFiIXtcbtg2KalQ": {"state": "ON", "address": "2109 Jane Street", "review_count": 38, "stars": 2.5, "name": "Mi Pho Song Vu", "city": "North York", "categories": ["Restaurants", "Thai", "Vietnamese", "Chinese"]},
  "kCoE3jvEtg6UVz5SOD3GVw": {"state": "NV", "address": "2620 Regatta Dr, Ste 102", "review_count": 5, "stars": 4.0, "name": "BDJ Realty", "city": "Las Vegas", "categories": ["Real Estate Services", "Real Estate", "Home Services", "Property Management"]},
  "b2I2DXtZVnpUMCXp1JON7A": {"state": "WI", "address": "2518 Ironwood Dr", "review_count": 9, "stars": 3.5, "name": "Meineke Car Care Center", "city": "Sun Prairie", "categories": ["Tires", "Oil Change Stations", "Auto Repair", "Automotive"]},
  "Q1MzgzH263RgYX4TU4xQ2Q": {"state": "NV", "address": "5060 S Fort Apache Rd, Ste 100", "review_count": 4, "stars": 2.0, "name": "Bridal Wear House", "city": "Las Vegas", "categories": ["Wedding Planning", "Fashion", "Formal Wear", "Event Planning & Services", "Bridal", "Party & Event Planning", "Shopping"]},
  "xMP2oDrKFqyUrN0Uww85EQ": {"state": "NC", "address": "3017 Kilborne Dr", "review_count": 3, "stars": 4.5, "name": "Dockside Seafood Market", "city": "Charlotte", "categories": ["Seafood Markets", "Food", "Specialty Food"]},
  "YTXTddeFATWYyCkopgaJig": {"state": "AZ", "address": "7100 W Chandler Blvd", "review_count": 3, "stars": 4.0, "name": "Triple R Child Care", "city": "Chandler", "categories": ["Preschools", "Child Care & Day Care", "Local Services", "Education", "Elementary Schools"]},
  "YhV93k9uiMdr3FlV4FHjwA": {"state": "AZ", "address": "", "review_count": 4, "stars": 5.0, "name": "Caviness Studio", "city": "Phoenix", "categories": ["Marketing", "Men's Clothing", "Restaurants", "Graphic Design", "Women's Clothing", "Screen Printing", "Advertising", "Pizza", "Shopping", "Web Design", "Fashion", "Local Services", "Screen Printing/T-Shirt Printing", "Professional Services"]},
  "VWNvhS3kUYU9qxiFudb6Ag": {"state": "AZ", "address": "12370 N 83rd Ave, Ste 11", "review_count": 4, "stars": 3.0, "name": "Violettas Custom Tailoring", "city": "Peoria", "categories": ["Sewing & Alterations", "Local Services"]},
  "K8dYoXbGDWJr_vSlVwDN1A": {"state": "ON", "address": "40 Bristol Rd E", "review_count": 4, "stars": 2.5, "name": "Garam Masala", "city": "Mississauga", "categories": ["Buffets", "Restaurants", "Indian"]},
  "5BjhQ_Tmm9ppK4UGrMr09g": {"state": "ON", "address": "2055 Dundas Street E", "review_count": 43, "stars": 4.0, "name": "Montreal Delicatessen & Family Restaurant", "city": "Mississauga", "categories": ["Restaurants", "Sandwiches", "Delis"]},
  "9AMePfa0ZQL7AWgazw7HfQ": {"state": "AZ", "address": "16815 E Shea Blvd, Ste 108", "review_count": 4, "stars": 2.5, "name": "European Nails & Spa", "city": "Fountain Hills", "categories": ["Beauty & Spas", "Nail Salons"]},
  "kKx8iCJkomVQBdWHnmmOiA": {"state": "AZ", "address": "10720 E Southern Ave", "review_count": 4, "stars": 2.5, "name": "Little Caesars Pizza", "city": "Mesa", "categories": ["Restaurants", "Pizza"]},
  "i8BUEXriiKa-RmOImgbqaQ": {"state": "QC", "address": "111 Rue Saint Paul Ouest", "review_count": 48, "stars": 3.5, "name": "Philemon Bar", "city": "Montréal", "categories": ["Bars", "Wine Bars", "Nightlife"]},
  "7YIy1tXOor9VCwvaSjuBHg": {"state": "AZ", "address": "3400 E Sky Harbor Blvd", "review_count": 46, "stars": 1.5, "name": "TSA Checkpoint T-4 A - Phoenix Sky Harbor International Airport", "city": "Phoenix", "categories": ["Public Services & Government"]},
  "lHYiCS-y8AFjUitv6MGpxg": {"state": "ON", "address": "85 Hanna Avenue", "review_count": 21, "stars": 4.0, "name": "Starbucks", "city": "Toronto", "categories": ["Food", "Coffee & Tea"]},
  "94KziT6DQ9XlBET3WzIv_w": {"state": "AZ", "address": "1928 S Gilbert Rd", "review_count": 4, "stars": 4.5, "name": "Fye", "city": "Mesa", "categories": ["Shopping", "Books", "Mags", "Music & Video", "Music & DVDs"]},
  "evwSIx2mmvpN0V0QteOAsA": {"state": "WI", "address": "4475 Robertson Rd", "review_count": 11, "stars": 3.0, "name": "Spay Me! Clinic", "city": "Madison", "categories": ["Veterinarians", "Pets"]},
  "WEouNHHxfqGa8gYAnyiyBA": {"state": "OH", "address": "5945 Andrews Rd", "review_count": 3, "stars": 3.5, "name": "El Palenque", "city": "Mentor-on-the-Lake", "categories": ["Restaurants", "Mexican"]},
  "zV_aclADLjx2KOql9F_FTw": {"state": "IL", "address": "313 E Green St, Ste 5", "review_count": 4, "stars": 3.0, "name": "Crepe Cafe", "city": "Champaign", "categories": ["Restaurants", "Creperies"]},
  "4K1_LooJ7smBLJcKaGMjUg": {"state": "QC", "address": "733 Rue Cathcart, Suite 6", "review_count": 6, "stars": 4.5, "name": "Hestia", "city": "Montréal", "categories": ["Coffee & Tea", "Food"]},
  "FtexOfH0spZrWcfj0LATiA": {"state": "NV", "address": "9300 Provence Garden Ln", "review_count": 5, "stars": 5.0, "name": "Green O' Aces Pools & Landscape", "city": "Las Vegas", "categories": ["Pool & Hot Tub Service", "Home Services", "Landscape Architects", "Active Life", "Contractors", "Swimming Pools", "Landscaping"]},
  "OcUVZniPo7CnIG-Tv83XcQ": {"state": "NV", "address": "8660 W Cheyenne Ave, Ste 120", "review_count": 3, "stars": 5.0, "name": "Karl M Larsen, OD", "city": "Las Vegas", "categories": ["Optometrists", "Health & Medical", "Eyewear & Opticians", "Shopping"]},
  "v2GJWvZqEAjUc22hZUYzYw": {"state": "NV", "address": "8125 W Sahara Ave, Ste 210", "review_count": 12, "stars": 4.5, "name": "John Armond Actor's Studio", "city": "Las Vegas", "categories": ["Education", "Performing Arts", "Specialty Schools", "Art Schools", "Arts & Entertainment"]},
  "VXH7zXcZzXlmAVN8GSjGRQ": {"state": "ON", "address": "4700 Keele Street", "review_count": 5, "stars": 3.0, "name": "Thai Express", "city": "Toronto", "categories": ["Imported Food", "Specialty Food", "Thai", "Ethnic Food", "Food", "Restaurants"]},
  "HNPipWcVQztvyPQ-S05_2Q": {"state": "AZ", "address": "922 S Country Club Dr", "review_count": 14, "stars": 4.0, "name": "Desert Wind Harley-Davidson", "city": "Mesa", "categories": ["Motorcycle Dealers", "Automotive"]},
  "mLP-jIIRdoaYM7fJqqFurw": {"state": "PA", "address": "2006 Murray Ave", "review_count": 53, "stars": 4.0, "name": "Napoli Pizzeria", "city": "Pittsburgh", "categories": ["Italian", "Pizza", "Restaurants", "Salad"]},
  "EXsmUB2mJyJsCpCV-56Ujw": {"state": "NV", "address": "5888 Spring Ranch Pkwy", "review_count": 16, "stars": 5.0, "name": "Paulina Clute Events", "city": "Las Vegas", "categories": ["Party & Event Planning", "Wedding Planning", "Event Planning & Services"]},
  "Kul8tFT48hZQJkeNK5jLBQ": {"state": "AZ", "address": "", "review_count": 10, "stars": 1.0, "name": "OutToday Plumbing Heating & Electrical", "city": "Scottsdale", "categories": ["Electricians", "Home Services", "Heating & Air Conditioning/HVAC", "Plumbing"]},
  "zzMu-6SmqhpvHxVRM6tx9g": {"state": "AZ", "address": "12614 N Cave Creek Rd, Ste 104", "review_count": 5, "stars": 4.0, "name": "Good Brakes Automotive", "city": "Phoenix", "categories": ["Oil Change Stations", "Smog Check Stations", "Automotive", "Auto Repair"]},
  "F0fEKpTk7gAmuSFI0KW1eQ": {"state": "NV", "address": "4250 S Rainbow Blvd, Ste 1007", "review_count": 3, "stars": 1.5, "name": "Cafe Mastrioni", "city": "Las Vegas", "categories": ["Italian", "Restaurants"]},
  "nAFI7JZEhmvUKMKSA_5Chg": {"state": "BW", "address": "Dorotheenstr. 6", "review_count": 7, "stars": 2.5, "name": "Nesenbach", "city": "Stuttgart", "categories": ["Cafes", "Nightlife", "Wine Bars", "Bars", "Restaurants"]},
  "gAy4LYpsScrj8POnCW6btQ": {"state": "SC", "address": "2429 Hwy 160 W", "review_count": 6, "stars": 3.5, "name": "Toast Cafe", "city": "Fort Mill", "categories": ["Food", "American (Traditional)", "Coffee & Tea", "Restaurants"]},
  "XG0twdTiMzUS3v3p9OZbJA": {"state": "ON", "address": "1881 Steeles Avenue W", "review_count": 3, "stars": 3.0, "name": "Winners", "city": "North York", "categories": ["Fashion", "Women's Clothing", "Accessories", "Shopping"]},
  "IHv_GCCzxVgmKSW1yb2jtA": {"state": "ON", "address": "32 St Andrew Street", "review_count": 10, "stars": 3.5, "name": "Shampoo Hair Studio", "city": "Toronto", "categories": ["Beauty & Spas", "Hair Salons"]},
  "KQPW8lFf1y5BT2MxiSZ3QA": {"state": "AZ", "address": "6025 N 27th Ave, Ste 1", "review_count": 18, "stars": 1.5, "name": "Western Motor Vehicle", "city": "Phoenix", "categories": ["Departments of Motor Vehicles", "Public Services & Government"]},
  "UXPgUZ-3ywG_tNKG41kaag": {"state": "AZ", "address": "", "review_count": 20, "stars": 5.0, "name": "Rising Phoenix Painting", "city": "Phoenix", "categories": ["Home Services", "Painters"]},
  "SJAggfn8ta7XLD98XD2mkw": {"state": "QC", "address": "975 Boulevard Roméo-Vachon Nord", "review_count": 11, "stars": 3.0, "name": "QDC Burger", "city": "Dorval", "categories": ["Burgers", "Fast Food", "Restaurants"]},
  "n7V4cD-KqqE3OXk0irJTyA": {"state": "NV", "address": "6587 Las Vegas Blvd S, Ste 171", "review_count": 349, "stars": 3.0, "name": "GameWorks", "city": "Las Vegas", "categories": ["Arcades", "Arts & Entertainment", "Gastropubs", "Restaurants", "American (New)"]},
  "nigYwB_m1TQ1WosjSWi-Hw": {"state": "AZ", "address": "1455 W Elliot Rd", "review_count": 5, "stars": 3.0, "name": "Simply Burgers", "city": "Gilbert", "categories": ["Burgers", "Restaurants"]},
  "xcgFnd-MwkZeO5G2HQ0gAQ": {"state": "ON", "address": "35 Main Street N", "review_count": 38, "stars": 4.0, "name": "T & T Bakery and Cafe", "city": "Markham", "categories": ["Bakeries", "Bagels", "Food"]},
  "ZmMCgM4RCqCXJ0Lswu6yxw": {"state": "NV", "address": "", "review_count": 17, "stars": 4.5, "name": "A Professional Appliance Repair", "city": "Las Vegas", "categories": ["Local Services", "Appliances & Repair"]},
  "Y0eMNa5C-YU1RQOZf9XvVA": {"state": "AZ", "address": "2414 South Gilbert Road", "review_count": 23, "stars": 5.0, "name": "CubeSmart Self Storage", "city": "Chandler", "categories": ["Local Services", "Self Storage"]},
  "oMH0Ac-Pke2Ph4btOXiQuw": {"state": "AZ", "address": "4025 E Chandler Blvd, Ste 22", "review_count": 18, "stars": 4.5, "name": "Hot Yoga Ahwatukee", "city": "Phoenix", "categories": ["Yoga", "Active Life", "Fitness & Instruction"]},
  "ww_MXl-qDLeYdYTZZ9KWbA": {"state": "ON", "address": "1156 College Street W", "review_count": 162, "stars": 4.0, "name": "Pho Linh", "city": "Toronto", "categories": ["Vietnamese", "Restaurants"]},
  "RV_NgH8wT1TuOs2qNt1WDg": {"state": "AZ", "address": "2765 N Scottsdale Rd, Ste 101", "review_count": 37, "stars": 3.5, "name": "Massage Envy - Scottsdale Thomas", "city": "Scottsdale", "categories": ["Massage", "Massage Therapy", "Health & Medical", "Skin Care", "Day Spas", "Beauty & Spas"]},
  "GDOAg680Gmi6S1MlhU7B1g": {"state": "OH", "address": "4110 Lee Road", "review_count": 5, "stars": 2.0, "name": "Taco Bell", "city": "Cleveland", "categories": ["Mexican", "Tex-Mex", "Restaurants", "Fast Food"]},
  "OD2hnuuTJI9uotcKycxg1A": {"state": "NV", "address": "7240 W Lake Mead Blvd, Ste 4", "review_count": 9, "stars": 1.5, "name": "Soccer Zone", "city": "Las Vegas", "categories": ["Shopping", "Sporting Goods"]},
  "M3uV9Y3EDSpy9d4YwyNSAQ": {"state": "AZ", "address": "10605 N 43rd Ave", "review_count": 66, "stars": 4.0, "name": "Yakiramen", "city": "Phoenix", "categories": ["Nightlife", "Japanese", "Music Venues", "Ramen", "Arts & Entertainment", "Restaurants", "Bars"]},
  "FmGZh8ZwEnSO860_2eiYHw": {"state": "PA", "address": "908 E 8th Ave", "review_count": 4, "stars": 3.0, "name": "Enterprise Rent-A-Car", "city": "Homestead", "categories": ["Hotels & Travel", "Car Rental"]},
  "0lCpaZpmjCFEmtti9O9ZdQ": {"state": "OH", "address": "12656 Chillicothe Rd", "review_count": 3, "stars": 3.5, "name": "LaPuma Bakery", "city": "Chesterland", "categories": ["Bakeries", "Food"]},
  "NoxzrJbWS4xD9ft0ygD3JA": {"state": "WI", "address": "701 E Washington Ave, Ste 105", "review_count": 30, "stars": 3.5, "name": "The Brink Lounge", "city": "Madison", "categories": ["Event Planning & Services", "Nightlife", "Lounges", "Venues & Event Spaces", "Bars"]},
  "qts-sjm1sj3oiT_Rch1zhQ": {"state": "NC", "address": "11215 Carolina Place Pkwy", "review_count": 6, "stars": 2.0, "name": "Men's Wearhouse", "city": "Pineville", "categories": ["Fashion", "Men's Clothing", "Shopping", "Plus Size Fashion", "Formal Wear"]},
  "GlZMZrA-whyu1INVXcvRnw": {"state": "OH", "address": "412 Superior Ave", "review_count": 3, "stars": 4.0, "name": "Al Wilhelmy Flowers, Inc.", "city": "Cleveland", "categories": ["Fruits & Veggies", "Shopping", "Specialty Food", "Flowers & Gifts", "Food", "Florists"]},
  "shNBn6mTKxZ124yPC_H02Q": {"state": "PA", "address": "248 Tara Dr", "review_count": 3, "stars": 3.5, "name": "T.W.Tile", "city": "Pittsburgh", "categories": ["Kitchen & Bath", "Countertop Installation", "Home Services", "Tiling", "Contractors", "Shopping", "Home & Garden"]},
  "dPxZI9lrKTl5dvFfnb1_Ig": {"state": "NV", "address": "9905 S Eastern Ave, Ste 140", "review_count": 210, "stars": 4.5, "name": "Trattoria Italia", "city": "Las Vegas", "categories": ["Seafood", "Italian", "Pizza", "Restaurants"]},
  "ZvvX30vgzBD2Ezd1zM33IQ": {"state": "NV", "address": "3050 E Desert Inn Rd, Ste 116", "review_count": 3, "stars": 3.5, "name": "Center For Behavioral Health", "city": "Las Vegas", "categories": ["Health & Medical", "Counseling & Mental Health"]},
  "GX83LORhO99mdNFz9_cZdQ": {"state": "AZ", "address": "6840 E Brown Rd", "review_count": 3, "stars": 2.5, "name": "Dayton Family Medicine", "city": "Mesa", "categories": ["Optometrists", "Doctors", "Internal Medicine", "Health & Medical"]},
  "98YzjvO45DRRvqrNv0hhAA": {"state": "ON", "address": "1900 Yonge St", "review_count": 131, "stars": 2.5, "name": "TTC - Toronto Transit Commision", "city": "Toronto", "categories": ["Hotels & Travel", "Transportation", "Public Transportation"]},
  "2pD9wZWXDNsZf_MXd8rQtg": {"state": "IL", "address": "602 W University Ave", "review_count": 6, "stars": 2.5, "name": "Carle Clinic Association", "city": "Urbana", "categories": ["Doctors", "Health & Medical"]},
  "o1fTwfqN0sDFNpV1CkOPPg": {"state": "PA", "address": "4032 Butler St", "review_count": 16, "stars": 3.5, "name": "Crazy Mocha Coffee", "city": "Pittsburgh", "categories": ["Restaurants", "Sandwiches", "Coffee & Tea", "Food"]},
  "lh2Lpra5q06qDxZeBQPOuQ": {"state": "AZ", "address": "9617 N Metro Parkway, West Space#2170", "review_count": 3, "stars": 3.5, "name": "Vans", "city": "Phoenix", "categories": ["Shopping", "Men's Clothing", "Shoe Stores", "Fashion", "Women's Clothing"]},
  "1WBkAuQg81kokZIPMpn9Zg": {"state": "AZ", "address": "777 E Thunderbird Rd, Ste 107", "review_count": 232, "stars": 3.0, "name": "Charr An American Burger Bar", "city": "Phoenix", "categories": ["Burgers", "Restaurants"]},
  "XSrN9gtLHC8MtUnSobZfDQ": {"state": "ON", "address": "231 Queen Street W", "review_count": 18, "stars": 4.0, "name": "Condom Shack", "city": "Toronto", "categories": ["Shopping", "Adult"]},
  "z1hRMOmEvw7jx4cq4-8Yfw": {"state": "QC", "address": "5885 Route Arthur-Sauvé", "review_count": 6, "stars": 3.5, "name": "La P'tite Cabane d'la Côte", "city": "Mirabel", "categories": ["Food", "Local Flavor", "Canadian (New)", "Sugar Shacks", "Restaurants", "American (Traditional)"]},
  "t2Eg5QRgLg9DWUeMe_Duhg": {"state": "QC", "address": "360 Rue Saint-Antoine O", "review_count": 23, "stars": 3.5, "name": "Sarah B.", "city": "Montreal", "categories": ["Bars", "Nightlife", "Cocktail Bars"]},
  "paN928wuyEHzxw7Zn5_snw": {"state": "OH", "address": "291 Crocker Park Blvd", "review_count": 4, "stars": 4.0, "name": "DSW Designer Shoe Warehouse", "city": "Westlake", "categories": ["Fashion", "Shoe Stores", "Shopping"]},
  "s16EYpC3UIxVoEs0JI-juQ": {"state": "ON", "address": "4309 Steeles Avenue W", "review_count": 3, "stars": 2.5, "name": "Euro Home Decor", "city": "Toronto", "categories": ["Home Services", "Shopping", "Home Decor", "Shades & Blinds", "Interior Design", "Building Supplies", "Home & Garden"]},
  "-jaX1hGZuerfwcNltMF_fg": {"state": "NV", "address": "7200 Arroyo Crossing Pkwy", "review_count": 3, "stars": 2.5, "name": "Jackson Hewitt Tax Service", "city": "Las Vegas", "categories": ["Financial Services", "Accountants", "Tax Services", "Professional Services"]},
  "8ksIhKcaFmzRX5pYA8cs0g": {"state": "NV", "address": "5275 S Durango Dr", "review_count": 3, "stars": 5.0, "name": "Lone Mortgage Steven Stewart", "city": "Las Vegas", "categories": ["Mortgage Brokers", "Financial Services", "Mortgage Lenders", "Real Estate", "Home Services"]},
  "EsMcGiZaQuG1OOvL9iUFug": {"state": "PA", "address": "2612 Brandt School Rd", "review_count": 15, "stars": 5.0, "name": "Any Given Sundae", "city": "Wexford", "categories": ["Coffee & Tea", "Ice Cream & Frozen Yogurt", "Food"]},
  "y7g-pgAFx37vKytP5oRD0Q": {"state": "NV", "address": "2833 N Green Valley Pkwy", "review_count": 18, "stars": 3.5, "name": "Bakery King", "city": "Henderson", "categories": ["Food", "Bakeries", "Donuts"]},
  "YgPz8vB7tw1B61qi_NLP9w": {"state": "QC", "address": "275 Avenue Fairmount O", "review_count": 18, "stars": 4.0, "name": "Kesté", "city": "Montréal", "categories": ["Italian", "Restaurants"]},
  "v3tBN6s8BhotnjA7GncQnQ": {"state": "ON", "address": "36 Eglinton Ave W, 2nd Floor", "review_count": 3, "stars": 3.5, "name": "Curves", "city": "Toronto", "categories": ["Health & Medical", "Active Life", "Weight Loss Centers", "Fitness & Instruction", "Trainers", "Nutritionists", "Gyms"]},
  "JX3ivaSLYcAmDS0HmLOxiA": {"state": "AZ", "address": "343 S Davis", "review_count": 11, "stars": 4.5, "name": "Eastside Performance", "city": "Mesa", "categories": ["Motorcycle Repair", "Automotive", "Motorcycle Dealers"]},
  "Zwh1Cn10m9Hy-T4TVPf0PA": {"state": "AZ", "address": "16630 W Greenway Rd", "review_count": 12, "stars": 2.5, "name": "West Valley Dental", "city": "Surprise", "categories": ["General Dentistry", "Dentists", "Health & Medical"]},
  "lj0MiK5_fyv9df2twnsI7g": {"state": "NV", "address": "2470 Paseo Verde Pkwy", "review_count": 3, "stars": 5.0, "name": "Pampered Hair Passionate about Hair", "city": "Henderson", "categories": ["Hair Salons", "Blow Dry/Out Services", "Hair Stylists", "Beauty & Spas", "Hair Extensions"]},
  "FYWN1wneV18bWNgQjJ2GNg": {"state": "AZ", "address": "4855 E Warner Rd, Ste B9", "review_count": 22, "stars": 4.0, "name": "Dental by Design", "city": "Ahwatukee", "categories": ["Dentists", "General Dentistry", "Health & Medical", "Oral Surgeons", "Cosmetic Dentists", "Orthodontists"]},
  "YvxQOMstU2MVDr2uNHs_vw": {"state": "OH", "address": "6130 Kruse Dr", "review_count": 42, "stars": 4.5, "name": "Mitchell's Ice Cream - Solon Shop", "city": "Solon", "categories": ["Ice Cream & Frozen Yogurt", "Food"]},
  "MTH-AcNyWfsBa9sXp04HcQ": {"state": "AZ", "address": "3420 E Baseline Rd, Ste 101", "review_count": 82, "stars": 3.5, "name": "Firehouse Subs", "city": "Mesa", "categories": ["Food", "Delis", "Fast Food", "Sandwiches", "Restaurants"]},
  "stDINY-WbudvOK9kfCX9Hw": {"state": "AZ", "address": "3111 W Chandler Blvd, Ste 2152", "review_count": 7, "stars": 3.5, "name": "Paris Optique", "city": "Chandler", "categories": ["Shopping", "Health & Medical", "Eyewear & Opticians", "Optometrists"]},
  "Rh2smrKvcamnP8VBUgMI0Q": {"state": "ON", "address": "421 Dundas St W, 3rd Fl", "review_count": 165, "stars": 3.5, "name": "Dim Sum King Seafood Restaurant", "city": "Toronto", "categories": ["Chinese", "Restaurants", "Dim Sum"]},
  "_ltkVUDwaI0MTxv8g21k1A": {"state": "QC", "address": "3035 Boulevard Le carrefour", "review_count": 3, "stars": 3.0, "name": "Manchu Wok", "city": "Laval", "categories": ["Fast Food", "Restaurants", "Chinese"]},
  "rDMptJYWtnMhpQu_rRXHng": {"state": "AZ", "address": "719 E Thunderbird Rd", "review_count": 10, "stars": 1.0, "name": "McDonald's", "city": "Phoenix", "categories": ["Fast Food", "Burgers", "Restaurants"]},
  "NmZtoE3v8RdSJEczYbMT9g": {"state": "PA", "address": "107 Whitaker Str", "review_count": 5, "stars": 2.0, "name": "Complete Dental Care", "city": "Homestead", "categories": ["General Dentistry", "Dentists", "Endodontists", "Cosmetic Dentists", "Health & Medical", "Orthodontists"]},
  "by_hdCLqAMHW8EEfPYjktA": {"state": "BW", "address": "Tübinger Str. 22", "review_count": 6, "stars": 3.0, "name": "Vital Lunch", "city": "Stuttgart", "categories": ["Food", "Caterers", "Restaurants", "Fast Food", "French", "Event Planning & Services", "Food Delivery Services"]},
  "z0BQG6LJOmd8E7cNuMtH0A": {"state": "QC", "address": "1003 Rue Sainte-Catherine E", "review_count": 3, "stars": 1.5, "name": "Jet Club", "city": "Montréal", "categories": ["Comedy Clubs", "Nightlife", "Shopping"]},
  "NXoGguzSd3DrsaGRIQXLpg": {"state": "AZ", "address": "3025 E Rose Garden Ln", "review_count": 71, "stars": 4.0, "name": "Deer Creek Animal Hospital", "city": "Phoenix", "categories": ["Pets", "Veterinarians", "Pet Services", "Pet Groomers", "Pet Sitting"]},
  "VSGcuYDV3q-AAZ9ZPq4fBQ": {"state": "ON", "address": "1430 Danforth Avenue", "review_count": 7, "stars": 2.5, "name": "Sportster's", "city": "Toronto", "categories": ["Bars", "Sports Bars", "Nightlife"]},
  "2Hv5ELUYvnkZtCLZaBhTcw": {"state": "NV", "address": "5820 S Pecos Rd, Ste 400", "review_count": 4, "stars": 5.0, "name": "Thy Word Ministries", "city": "Las Vegas", "categories": ["Churches", "Religious Organizations"]},
  "VBHEsoXQb2AQ76J9l8h1uQ": {"state": "NV", "address": "5775 S Eastern, Ste 103", "review_count": 23, "stars": 4.5, "name": "Alfredo's Jewelry", "city": "Las Vegas", "categories": ["Shopping", "Jewelry", "Watch Repair", "Local Services"]},
  "tRVx2c89coruPRwYhGTcTw": {"state": "OH", "address": "13603 Madison Ave", "review_count": 78, "stars": 3.5, "name": "Yuzu", "city": "Lakewood", "categories": ["Nightlife", "Izakaya", "Comfort Food", "Cocktail Bars", "Asian Fusion", "Bars", "Japanese", "Restaurants", "Gastropubs", "Tapas/Small Plates"]},
  "TGWhGNusxyMaA4kQVBNeew": {"state": "NV", "address": "", "review_count": 7, "stars": 5.0, "name": "Detailing Gone Mobile", "city": "Henderson", "categories": ["Automotive", "Auto Detailing"]},
  "2W4ib_VaQecBX5QsROf6tA": {"state": "AZ", "address": "2401 W Van Buren St", "review_count": 20, "stars": 4.0, "name": "Penny Pincher", "city": "Phoenix", "categories": ["Auto Parts & Supplies", "Automotive"]},
  "DPQnTnNw2PJj7DdENM98Cw": {"state": "NV", "address": "5340 Boulder Hwy", "review_count": 25, "stars": 3.5, "name": "Star Nursery", "city": "Las Vegas", "categories": ["Nurseries & Gardening", "Home & Garden", "Shopping"]},
  "4srfPk1s8nlm1YusyDUbjg": {"state": "NV", "address": "6889 S Eastern Ave, Ste 101", "review_count": 6, "stars": 2.5, "name": "Subway", "city": "Las Vegas", "categories": ["Fast Food", "Restaurants", "Sandwiches"]},
  "sJ0MYSAIVK28cMzh-s-NPA": {"state": "ON", "address": "Eaton Centre, 220 Yonge St", "review_count": 34, "stars": 2.5, "name": "Amaya Express", "city": "Toronto", "categories": ["Indian", "Restaurants", "Fast Food"]},
  "mtTxLi9CZNOsDqOTJH3pQw": {"state": "NC", "address": "516 E 15th St, Ste 11D", "review_count": 4, "stars": 3.0, "name": "Felicitea", "city": "Charlotte", "categories": ["Food", "Coffee & Tea", "Massage", "Beauty & Spas"]},
  "IQSlT5jGE6CCDhSG0zG3xg": {"state": "AZ", "address": "8411 W Thunderbird Rd, Unit 101", "review_count": 20, "stars": 3.0, "name": "T & Y Nail Spa", "city": "Peoria", "categories": ["Beauty & Spas", "Nail Salons"]},
  "Z-4KHBDbdwyC7PwA_JE5Xw": {"state": "WI", "address": "2701 University Ave, Ste H", "review_count": 14, "stars": 4.5, "name": "William Jon Salon & Spa", "city": "Madison", "categories": ["Tanning", "Day Spas", "Spray Tanning", "Beauty & Spas", "Hair Salons"]},
  "5q6Xh-UcJa78bp6dzyaE7w": {"state": "NC", "address": "1710 Kenilworth Ave, Ste 220", "review_count": 373, "stars": 4.5, "name": "Duck Donuts", "city": "Charlotte", "categories": ["Breakfast & Brunch", "Food", "Coffee & Tea", "Donuts", "Restaurants"]},
  "PJ-VbAtIOso1dqd2frQqqg": {"state": "NV", "address": "4268 E Charleston Blvd", "review_count": 76, "stars": 4.5, "name": "Donut Tyme", "city": "Las Vegas", "categories": ["Donuts", "Food"]},
  "8eMOA7u2tubyfd01EZJ8Rg": {"state": "AZ", "address": "6131 W Thomas Rd Ofc", "review_count": 5, "stars": 2.5, "name": "Brookside Apartments", "city": "Phoenix", "categories": ["Real Estate", "Home Services", "Apartments"]},
  "vzx1WdVivFsaN4QYrez2rw": {"state": "NV", "address": "5111 Boulder Hwy", "review_count": 3, "stars": 3.0, "name": "Subway", "city": "Las Vegas", "categories": ["Sandwiches", "Restaurants", "Fast Food"]},
  "WUiDaFQRZ8wKYGLvmjFjAw": {"state": "NC", "address": "8630 University Executive Park Dr", "review_count": 76, "stars": 3.5, "name": "China Buffet", "city": "Charlotte", "categories": ["Buffets", "Restaurants", "Sushi Bars", "Chinese"]},
  "RAUI7uwpMP6dlcHXkavwHg": {"state": "AZ", "address": "5215 W Baseline Rd", "review_count": 23, "stars": 3.0, "name": "Smashburger", "city": "Laveen", "categories": ["Burgers", "Restaurants"]},
  "5qpi5VQ_S2Itm8xvRm1k8Q": {"state": "AZ", "address": "28212 N Tatum Blvd, Ste D4", "review_count": 9, "stars": 5.0, "name": "Olsen Firearms", "city": "Cave Creek", "categories": ["Shopping", "Guns & Ammo"]},
  "VdlPZg2NAu8t8GkdbPLecg": {"state": "AZ", "address": "8140 N Hayden Rd, Ste H115", "review_count": 263, "stars": 3.5, "name": "Tandoori Times Indian Bistro", "city": "Scottsdale", "categories": ["Restaurants", "Gluten-Free", "Indian", "Seafood"]},
  "xiSEUnaX77EhNz-l3ag7RA": {"state": "NV", "address": "8530 W Warm Spring Rd, Ste 105", "review_count": 56, "stars": 4.5, "name": "LV Nail Lounge", "city": "Las Vegas", "categories": ["Hair Removal", "Beauty & Spas", "Waxing", "Nail Salons"]},
  "pR6Fy9cP3oAzM_DtloLV5w": {"state": "NV", "address": "3340 Sunrise Ave, Ste 101", "review_count": 4, "stars": 4.0, "name": "Edged Enterprises", "city": "Las Vegas", "categories": ["Contractors", "Arts & Crafts", "Shopping", "Flooring", "Home Services"]},
  "XPZT3zLrkLkFSkBVxSsM3w": {"state": "AZ", "address": "7000 E Mayo Blvd Building 15", "review_count": 21, "stars": 2.5, "name": "Sports Authority", "city": "Phoenix", "categories": ["Sporting Goods", "Shopping"]},
  "onb5syYKz4Wf3cwQWuqv1A": {"state": "NV", "address": "3250 Civic Center Dr", "review_count": 13, "stars": 5.0, "name": "Recinos Shoe Repair", "city": "North Las Vegas", "categories": ["Sewing & Alterations", "Local Services", "Shoe Repair"]},
  "KbSoYXHUz_Bjo-v0VWHDrw": {"state": "EDH", "address": "St Andrew Sq", "review_count": 14, "stars": 4.5, "name": "St. Andrew Square", "city": "Edinburgh", "categories": ["Active Life", "Parks", "Local Flavor"]},
  "LrYSnxLKarkzeNHqq50r-A": {"state": "ON", "address": "2425 Truscott Dr", "review_count": 22, "stars": 4.0, "name": "Truscott Italian Bakery & Delicatessen", "city": "Mississauga", "categories": ["Food", "Delis", "Bakeries", "Restaurants"]},
  "Vl9UFifPCWTGKdogF5gnvw": {"state": "AZ", "address": "7349 Via Paseo Del Sur, Ste 515", "review_count": 8, "stars": 3.0, "name": "Perfection Plus Carpet & Tile Cleaning", "city": "Gilbert", "categories": ["Tiling", "Carpet Cleaning", "Home Services", "Refinishing Services", "Local Services"]},
  "iPa__LOhse-hobC2Xmp-Kw": {"state": "AZ", "address": "1635 E Camelback Rd", "review_count": 34, "stars": 3.0, "name": "McDonald's", "city": "Phoenix", "categories": ["Restaurants", "Burgers", "Fast Food"]},
  "gSr8zPc8M4eTxwGgPb5AsA": {"state": "PA", "address": "601 4th Ave", "review_count": 26, "stars": 4.5, "name": "Coraopolis Collision and Repair Service", "city": "Coraopolis", "categories": ["Smog Check Stations", "Automotive", "Auto Repair", "Body Shops"]},
  "HyE2qiMaz7HMJWDhunHA4A": {"state": "NV", "address": "120 E Merlayne Dr", "review_count": 26, "stars": 3.5, "name": "Underground Diesel", "city": "Henderson", "categories": ["Auto Parts & Supplies", "Automotive", "Auto Repair"]},
  "HAX1zec191t7QkT2sBZ76A": {"state": "NC", "address": "1816 Galerea Blvd, Ste D", "review_count": 4, "stars": 3.0, "name": "La Isla Cuban Restaurant", "city": "Charlotte", "categories": ["Restaurants", "Cuban"]},
  "g-DJdpZnDpZ3gGpNxitxkA": {"state": "NC", "address": "7427 Matthews-Mint Hill Rd", "review_count": 4, "stars": 5.0, "name": "Creative Home Stagers", "city": "Mint Hill", "categories": ["Home Services", "Real Estate"]},
  "nSD-uxCMb745bH3dxoko9Q": {"state": "SC", "address": "2453 HWY 160", "review_count": 13, "stars": 4.0, "name": "Taco Bell", "city": "Tega Cay", "categories": ["Tex-Mex", "Mexican", "Restaurants", "Fast Food"]}
}
