#-----------------------------#
# Define your test cases here #
#-----------------------------#

import optimism

import animalQuiz

# Tests for boolFromResponse
testBFR = optimism.testFunctionMaybe(animalQuiz, "boolFromResponse")
testBFR.case('yes').checkReturnValue(True)
testBFR.case('Yes').checkReturnValue(True)
testBFR.case('Yes!').checkReturnValue(True)
testBFR.case('y').checkReturnValue(True)
testBFR.case('yellow').checkReturnValue(True)
testBFR.case('No').checkReturnValue(False)
testBFR.case('no').checkReturnValue(False)
testBFR.case('Nope').checkReturnValue(False)
testBFR.case('N').checkReturnValue(False)
testBFR.case('maybe').checkReturnValue(False)
testBFR.case('affirmative').checkReturnValue(False)
testBFR.case('123').checkReturnValue(False)

# A few test cases for boolFromUser (since we tested
# boolFromResponse thoroughly, we're not as worried about
# boolFromUser).
testBFU = optimism.testFunctionMaybe(animalQuiz, "boolFromUser")
case1 = testBFU.case("Are you awesome? ")
case1.provideInputs("Yes.")
case1.checkPrintedLines("Are you awesome? Yes.")
case1.checkReturnValue(True)

case2 = testBFU.case("Are you testing me? ")
case2.provideInputs("Yes.")
case2.checkPrintedLines("Are you testing me? Yes.")
case2.checkReturnValue(True)

case3 = testBFU.case("Are you serious? ")
case3.provideInputs("no")
case3.checkPrintedLines("Are you serious? no")
case3.checkReturnValue(False)

# Test cases for all 8 possible chooseAnimal combinations
testCA = optimism.testFunctionMaybe(animalQuiz, "chooseAnimal")
testCA.case(True, True, True).checkReturnValue('polar bear')
testCA.case(True, True, False).checkReturnValue('orca')
testCA.case(True, False, True).checkReturnValue('tiger')
testCA.case(True, False, False).checkReturnValue('komodo dragon')
testCA.case(False, True, True).checkReturnValue('yak')
testCA.case(False, True, False).checkReturnValue('clam')
testCA.case(False, False, True).checkReturnValue('bunny')
testCA.case(False, False, False).checkReturnValue('tortoise')


# A few test cases for animal quiz. Having tested both
# chooseAnimal and boolFromUser/boolFromResponse thoroughly,
# we're not testing every possibility here.
testAQ = optimism.testFunctionMaybe(animalQuiz, "animalQuiz")
case1 = testAQ.case()
case1.provideInputs("yes", "yes", "no")
case1.checkPrintedLines(
    "What animal are you? Let's find out!",
    "Do you like to eat meat? yes",
    "Do you like cold weather? yes",
    "Do you like fuzzy things? no",
    "",
    "Your animal is the orca"
)

case2 = testAQ.case()
case2.provideInputs("haha", "what?", "you're kidding!")
case2.checkPrintedLines(
    "What animal are you? Let's find out!",
    "Do you like to eat meat? haha",
    "Do you like cold weather? what?",
    "Do you like fuzzy things? you're kidding!",
    "",
    "Your animal is the bunny"
) # note that the last input counts a 'yes'

case3 = testAQ.case()
case3.provideInputs("no", "yes", "nope")
case3.checkPrintedLines(
    "What animal are you? Let's find out!",
    "Do you like to eat meat? no",
    "Do you like cold weather? yes",
    "Do you like fuzzy things? nope",
    "",
    "Your animal is the clam"
)
