"""
Authors: Peter Mawhorter
Consulted:
Date: 2022-3-1
Purpose: Testing code for circles task: tests the turtleBeads printed
  output to check that circles are drawn correctly.
"""

import circles
import turtleBeads

import optimism


turtleBeads.noTrace()
testCC = optimism.testFunctionMaybe(circles, "concentricCircles")
turtleBeads.teleport(-200, 200)
testCC.case(60, 3, "HotPink", "LightSkyBlue1").checkPrintedLines(
    "A HotPink dot at (-200, 200) with radius 60",
    "A LightSkyBlue1 dot at (-200, 200) with radius 40",
    "A HotPink dot at (-200, 200) with radius 20",
)
turtleBeads.teleport(150, 120)
testCC.case(190, 4, "LightSalmon2", "Khaki1").checkPrintedLines(
    "A LightSalmon2 dot at (150, 120) with radius 190",
    "A Khaki1 dot at (150, 120) with radius 142",
    "A LightSalmon2 dot at (150, 120) with radius 95",
    "A Khaki1 dot at (150, 120) with radius 48",
)

testMC = optimism.testFunctionMaybe(circles, "multicolorCircles")
turtleBeads.teleport(200, -200)
testMC.case(16, ["black", "blue", "red", "yellow"], 1).checkPrintedLines(
    "A black dot at (200, -200) with radius 64",
    "A blue dot at (200, -200) with radius 48",
    "A red dot at (200, -200) with radius 32",
    "A yellow dot at (200, -200) with radius 16",
)

turtleBeads.teleport(-150, -130)
testMC.case(
    12,
    ['red', 'orange', 'yellow', 'green', 'blue',
     'navy', 'purple3'],
    2
).checkPrintedLines(
    "A red dot at (-150, -130) with radius 168",
    "A orange dot at (-150, -130) with radius 156",
    "A yellow dot at (-150, -130) with radius 144",
    "A green dot at (-150, -130) with radius 132",
    "A blue dot at (-150, -130) with radius 120",
    "A navy dot at (-150, -130) with radius 108",
    "A purple3 dot at (-150, -130) with radius 96",
    "A red dot at (-150, -130) with radius 84",
    "A orange dot at (-150, -130) with radius 72",
    "A yellow dot at (-150, -130) with radius 60",
    "A green dot at (-150, -130) with radius 48",
    "A blue dot at (-150, -130) with radius 36",
    "A navy dot at (-150, -130) with radius 24",
    "A purple3 dot at (-150, -130) with radius 12",
)
turtleBeads.showPicture()
