"""
Authors:
Consulted:
Date:
Purpose: manipulates strings of 'A', 'C', 'U', 'T', and 'G' letters
representing DNA and RNA base pairs.
"""


#---------------#
# Provided Code #
#---------------#

def templateBase(base):
    """
    Given an RNA base ('A', 'U', 'G', or 'C') this function returns the
    DNA base that serves as a template for that base ('T' for 'A', 'A'
    for 'U', 'C' for 'G', and 'G' for 'C').
    """
    if base == 'A':
        return 'T'
    elif base == 'U':
        return 'A'
    elif base == 'G':
        return 'C'
    elif base == 'C':
        return 'G'
    else:
        raise ValueError("{} is not a valid RNA base!".format(repr(base)))


#-----------#
# Your Code #
#-----------#
