"""
Authors: Peter Mawhorter
Consulted:
Date: 2022-2-20
Purpose: Tests for genetics task.
"""

import optimism

import genetics

testCOB = optimism.testFunctionMaybe(genetics, "countOtherBases")
testCOB.case("GAUUACA", "A").checkReturnValue(4)
testCOB.case("GAUUACA", "G").checkReturnValue(6)
testCOB.case("AAA", "G").checkReturnValue(3)
testCOB.case("AAA", "A").checkReturnValue(0)
testCOB.case("", "G").checkReturnValue(0)

testTS = optimism.testFunctionMaybe(genetics, "templateSequence")
testTS.case("GACU").checkReturnValue("CTGA")
# TODO: Add more test cases

testOAU = optimism.testFunctionMaybe(genetics, "onlyAU")
testOAU.case("GUACGU").checkReturnValue("UAU")
# TODO: Add more test cases

testTE = optimism.testFunctionMaybe(genetics, "transcriptionErrors")
testTE.case("AAA", "TTC").checkReturnValue(1)
# TODO: Add more test cases

testHCGB = optimism.testFunctionMaybe(genetics, "hasCGBlock")
testHCGB.case("CGGCC").checkReturnValue(True)
# TODO: Add more test cases

print("Did you remember to add extra test cases?")
print("You can delete these messages once you've done so.")
