"""
Authors: Peter Mawhorter
Consulted:
Date: 2022-2-11
Purpose: Testing code for mazePolicies task. Uses maze library's built-in
  testing functions to demonstrate results of various policies on various
  mazes. You should modify this to test the maze/policy combinations
  you're interested in.
"""

import maze
import mazePolicies

# If you'd prefer to see the trace of surroundings or the text-based
# animation, change this variable by swapping which definition is
# commented in. By default we'll use animateText because it leaves a
# record you can scroll through, unlike animateTurtle.

# test = maze.traceSurroundings
test = maze.animateText
# test = maze.animateTurtle


# This is an example test which uses the simplest policy and maze
# You can set the last argument to something other than 25 to draw
# faster or slower.
test(maze.MAZE0, mazePolicies.turnAroundPolicy, 100, 25)

# Change the maze & policy used above to test your own policies on more
# complex mazes. Some combinations you might want to try:

# maze.MAZE4 cannot be solved by the mazePolicies.turnAroundPolicy

# maze.MAZE3 can be solved by the mazePolicies.bouncePolicy, but
#   maze.Maze4 cannot.

# The mazePolicies.leftWallPolicy can solve maze.MAZE4, and also
#   maze.MAZE6, but it cannot solve maze.MAZE8.

# You should test mazes 7-12 with mazePolicies.customPolicy if you want
# to tackle the extra goal requiring that it solve at least three of
# them.
