"""
Authors: Peter Mawhorter
Consulted
Date: 2022-2-1
Purpose: Example of monster functions for monsterMash task. Defines
  tail, body, and head functions, and a monster function that puts them
  together. This green monster has a triangle tail, a rectangular body
  with a wing, and a hexagonal head.
"""


from turtle import *
from turtleBeads import *


def greenTail():
    """
    Draws the green monster's curvy tail with a triangle at the end. Puts
    the turtle back where it started.
    """
    color("PaleGreen3")
    pensize(18)

    # How big are the curves?
    tailCurveRadius = 40

    # Turn around to draw the tail facing left, and move down a bit
    lt(180)
    hop(18)

    # Draw wavy tail:
    circle(tailCurveRadius, 70)
    circle(-tailCurveRadius, 110)

    # Move forward and turn sideways to draw triangular tail tip:
    pensize(3)
    fd(12)
    lt(90)
    begin_fill()
    drawPolygon(32, 3)
    end_fill()
    rt(90)

    # Turn around and go back:
    penup()
    bk(12)
    lt(180)
    circle(tailCurveRadius, 110)
    circle(-tailCurveRadius, 70)
    pendown()
    hop(18)


def drawWingSegment(baseSize):
    """
    Helper to draw part of a wing (triangle w/ 2 sides stroked and 1
    open).
    """
    begin_fill()
    fd(baseSize)
    lt(120)
    leap(baseSize)
    lt(120)
    fd(baseSize)
    end_fill()


def greenBody():
    """
    The green monster body is a simple rectangle with complicated wings.
    The turtle is placed 100 units ahead of its initial starting location
    when the function is done.
    """
    color("PaleGreen4")
    pensize(5)

    # Move to center:
    leap(50)
    hop(-25)

    # Draw rectangular body:
    begin_fill()
    drawRectangle(100, 50)
    end_fill()

    # Set lighter green for lines:
    pencolor("PaleGreen3")
    fillcolor("PaleGreen")
    pensize(7)

    # Move to shoulder:
    leap(25)
    lt(90)
    leap(12)
    rt(30)

    # Draw wing:
    fd(50)
    lt(30)
    # Two equilateral triangles:
    drawWingSegment(70)
    rt(180)
    drawWingSegment(70)

    # Move back to shoulder
    lt(30)
    leap(-50)

    # Move to the upper-right corner of the body
    lt(30)
    leap(13)
    rt(90)
    leap(25)


def greenHead():
    """
    The green monster head has a thick line for a neck and a hexagonal
    face. This function moves the turtle back to its starting location
    when it's done.
    """
    # Set up color and size
    color("PaleGreen3")
    pensize(18)

    # Move down a bit
    hop(-18)

    # Turn and draw the neck
    lt(30)
    fd(50)

    # Realign and draw the face
    rt(30)
    begin_fill()
    drawPolygon(20, 6)
    end_fill()

    # Draw the eye
    lt(50)
    leap(12)
    pencolor("PaleGreen4")
    drawDot(5)

    # Draw the mouth
    lt(65)
    leap(-27)
    lt(45)
    pensize(3)
    fd(10)

    # Back up to the starting point
    # Note: here instead of trying to figure out mathematically where to
    # go, we simply replay all of our previous movements in reverse order
    # with reversed parameters.
    # Reverse mouth
    leap(-10)
    rt(45)
    leap(27)
    rt(65)

    # Reverse eye
    leap(-12)
    rt(50)

    # Reverse head
    lt(30)

    # Reverse neck
    leap(-50)
    rt(30)

    # move back to the starting position
    hop(18)


def greenMonster():
    """
    Draws a green monster using all three pieces, with the back hip
    placed where the cursor starts. Draws the tail first, then the body,
    and finally the head. Leaves the cursor 100 units ahead of where it
    started, in the same orientation.
    """
    greenTail()
    greenBody()
    greenHead()
