"""
Authors: Peter Mawhorter
Consulted
Date: 2022-2-1
Purpose: Example of monster functions for monsterMash task. Defines
  tail, body, and head functions, and a monster function that puts them
  together. This yellow monster has a zig-zag tail, a zig-zag body with
  fins, and a triangular head.
"""


from turtle import *
from turtleBeads import *


def yellowTail():
    """
    Draws the yellow monster's zig-zag tail. Puts the turtle back where
    it started when it's done.
    """
    # Set the pen/fill colors and pen size
    color("Yellow")
    pensize(1)

    # The square root of three, for computing 30-60-90 triangle sizes
    root3 = 3**0.5

    # move the tail down a bit to center relative to the standard body
    # size
    hop(-14)

    # Turn around to draw the tail facing left
    lt(150)

    # Draw zig zags:
    begin_fill() # start filled shape
    # 30-60-90 triangle has hypotenuse 2a and long edge sqrt(3)a...
    # we want to move 30 units horizontally, so sqrt(3)a = 30
    # therefore, 2a = 2 * (30/sqrt(3))
    fd(2 * 30/root3)
    lt(60)
    fd(2 * 20/root3)
    rt(60)
    fd(2 * 15/root3)

    # Returning path

    # This angle is 30 degrees to face West, then 180 to face East, minus
    # 30 for the angle of the previous line and 30 more to make a
    # 30-degree angle with that last line, and a 60-degree angle with the
    # horizontal. Writing '150' would also be okay of course.
    lt(30 + (180 - (30 + 30)))
    fd(30) # now we're the hypotenuse and the horizontal is 1/2
    lt(90) # back to +30 relative to the horizontal
    fd(2 * 20/root3) # matches second line above
    rt(60) # -30 now
    fd(2 * 30/root3)
    lt(30 + 90) # face North
    # net y-axis movement is all due to the fd(30), which moved us
    # 30/sqrt(3) South
    fd(30/root3)
    end_fill()

    # Return to starting orientation
    rt(90)

    # hop back up to the starting location
    hop(14)


def drawFin():
    """
    Helper to draw a fin (several lines radiating from a base point, with
    a darker triangle behind them). The triangle points back and to the
    left of the turtle, and the turtle is returned to its original
    position when done.
    """
    pencolor("Gold2")
    fillcolor("Gold3")
    pensize(1)
    lt(190) # 180 + 10

    # an equilateral triangle
    webSize = 25
    begin_fill()
    fd(webSize)
    lt(120)
    fd(webSize)
    lt(120)
    fd(webSize)
    lt(120)
    end_fill()

    # four lines
    pensize(4)
    fd(25)
    leap(-25)
    lt(60/3)
    fd(25)
    leap(-25)
    lt(60/3)
    fd(25)
    leap(-25)
    lt(60/3)
    fd(25)
    leap(-25)

    # Turn back to original facing
    lt(180 - 10 - 60)


def yellowBody():
    """
    The yellow monster body is a big zig-zag shape with fins. The turtle
    ends up 100 units ahead of where it started, facing in the same
    direction.
    """
    # Set up color + pen size
    color("yellow")
    pensize(1)

    # The square root of three, for computing 30-60-90 triangle sizes
    root3 = 3**0.5

    # How tall the body will be
    bodyHeight = 65

    # How far down to place the fin
    finHeight = 30 

    # we'll fill the whole body shape...
    begin_fill()

    # zig upwards, then zag down, then zig back upwards
    lt(30)
    # 30 units horizontally
    fd(2 * 30/root3)

    rt(60) # now angled 30 degrees downwards
    # this time sqrt(3)a = 40
    fd(2 * 40/root3)

    lt(60) # angles 30 degrees back up
    # same as first line; should put us back at original y; +100 in x
    fd(2 * 30/root3)

    rt(120) # point south

    fd(bodyHeight) # south along front of body

    lt(120) # position to do the bottom zig-zag backwards
    bk(2 * 30/root3)

    rt(60)
    bk(2 * 40/root3)

    lt(60)
    bk(2 * 30/root3)

    # back up to our original position and fill the shape
    lt(60)
    fd(bodyHeight)
    end_fill()

    # Leap over to the end position
    rt(90)
    leap(100)

    # position for fin
    leap(-20)
    hop(-finHeight)

    # draw fin
    drawFin()

    # return to end point
    hop(finHeight)
    leap(20)


def yellowHead():
    """
    The yellow monster head has a zig-zag neck and a triangle head.
    """
    # Set up color and size
    pencolor("Gold2")
    fillcolor("Yellow")
    pensize(8)

    # Move down a bit
    hop(-15)

    # Turn and draw the neck
    lt(30)
    fd(15)
    rt(60)
    fd(20)
    lt(60)
    fd(15)
    rt(30)

    # draw the head
    color("yellow")
    pensize(1)
    headSize = 40
    begin_fill()
    lt(90)
    fd(headSize/2)
    rt(120)
    fd(headSize) # 30-60-90 triangle
    rt(120)
    fd(headSize)
    rt(120)
    fd(headSize/2)
    rt(90) # back to original orientation
    end_fill()

    # Draw the eye
    lt(20)
    leap(headSize/3)
    pencolor("Gold3")
    drawDot(3)
    leap(-headSize/3)
    rt(20)

    # Back up to the starting point

    # reverse neck
    lt(30)
    leap(-15)
    rt(60)
    leap(-20)
    lt(60)
    leap(-15)
    rt(30)

    # back to shoulder
    hop(15)


def yellowMonster():
    """
    Draws a yellow monster using all three pieces. Draws the tail first,
    then the body, and finally the head. Leaves the cursor 100 units
    ahead of the starting position, in the same orientation.
    """
    yellowTail()
    yellowBody()
    yellowHead()
