"""
Authors: 
Consulted:
Date: 2024-2-5
Purpose: musicalMeasures task: plays a song with melody, harmony, and
    rhythm parts.
"""

# Main library for creating music
from wavesynth import *


#---------------------------#
# Provided code (Subtask A) #
#---------------------------#

def chord(duration):
    """
    Adds a three-note major chord with the given duration, with the
    first note at the current pitch and the second and third four and
    then seven half steps above it.

    Leaves the current pitch and volume unchanged by the end, but
    advances the time by the specified duration.
    """
    # Make the whole thing slightly quieter
    quieter(3)

    # Add the first note
    addNote(duration)
    # Rewind so that they overlap
    rewind(duration)

    # Move up to add the second note
    halfStepUp(4)

    # Add the second note
    addNote(duration)
    rewind(duration)

    halfStepUp(3)
    addNote(duration)
    # No final rewind

    # Return to the starting pitch and volume
    halfStepDown(7)
    louder(3)


#----------------#
# Your code here #
#----------------#
