"""
Authors: Peter Mawhorter
Consulted:
Date: 2024-2-5
Purpose: Testing code for musicalMeasures task. Tests each function if
it's been defined, and checks that the invariant "pitch gets put back
where it started" is maintained by `main` as a whole, but does NOT check
the invariant for each specific function.

Note that if your `musicalMeasures` function calls `main` itself, this
will play your song twice.
"""

import optimism
import wavesynth

import musicalMeasures

testChord = optimism.testFunctionMaybe(musicalMeasures, "chord")
testChord.checkCodeContains(optimism.Call("addNote", min=2))

testMelody = optimism.testFunctionMaybe(musicalMeasures, "melody")
testMelody.checkCodeContains(optimism.Call("addNote", min=2))
testMelody.checkCodeContains(
    optimism.MatchAny(
        optimism.Call("climbUp"),
        optimism.Call("climbDown"),
        optimism.Call("halfStepUp"),
        optimism.Call("halfStepDown"),
        optimism.Call("leapUp"),
        optimism.Call("leapDown"),
    )
)
testMelody.checkCodeContains(optimism.Call("rewind", max=0))

testRhythm = optimism.testFunctionMaybe(musicalMeasures, "rhythm")
testRhythm.checkCodeContains(optimism.Call("addBeat", min=2))
testRhythm.checkCodeContains(optimism.Call("rewind", max=0))

testHarmony = optimism.testFunctionMaybe(musicalMeasures, "harmony")
testHarmony.checkCodeContains(optimism.Call("chord", min=2))
testHarmony.checkCodeContains(
    optimism.MatchAny(
        optimism.Call("climbUp"),
        optimism.Call("climbDown"),
        optimism.Call("halfStepUp"),
        optimism.Call("halfStepDown"),
        optimism.Call("leapUp"),
        optimism.Call("leapDown"),
    )
)
testHarmony.checkCodeContains(optimism.Call("rewind", max=0))

testPhrase = optimism.testFunctionMaybe(musicalMeasures, "phrase")
testPhrase.checkCodeContains(optimism.Call("melody"))
testPhrase.checkCodeContains(optimism.Call("rhythm"))
testPhrase.checkCodeContains(optimism.Call("harmony"))
testPhrase.checkCodeContains(optimism.Call("rewind", min=2))

testSong = optimism.testFunctionMaybe(musicalMeasures, "song")
testSong.checkCodeContains(optimism.Call("phrase", min=2))

testMain = optimism.testFunctionMaybe(musicalMeasures, "main")
testMain.checkCodeContains(optimism.Call("song"))

print("Checking for pitch changes by main function...")
print("Starting at pitch B4...")
wavesynth.setPitch(wavesynth.B4)
musicalMeasures.main()
optimism.expect(wavesynth.currentPitchName(), 'B4')
print("...final pitch is:", wavesynth.currentPitchName())
