"""
Authors: Peter Mawhorter
Consulted:
Date: 2022-3-1
Purpose: Runs the scales functions and plays the results so you can hear
  them.
"""

import wavesynth

import scales

# Uncomment the blocks below for the function(s) you'd like to hear the
# output of. The longer the track, the longer it will take to compile
# it, so running many tests at once is not recommended.

print("Testing scale(0.75, 3) from C4")
wavesynth.setPitch(wavesynth.C4)
scales.scale(0.75, 3)

# print("Testing scale(0.64, 8) from B2")
# wavesynth.setPitch(wavesynth.B2)
# scales.scale(0.64, 8)

# print("Testing unevenScale(3, 0.75, 0.25) from C4")
# wavesynth.setPitch(wavesynth.C4)
# scales.unevenScale(3, 0.75, 0.25)

# print("Testing unevenScale(8, 0.4, 0.5) from E2")
# wavesynth.setPitch(wavesynth.E2)
# scales.unevenScale(8, 0.4, 0.5)

# print("Testing arpeggio(0.25, [2, 3], 3) from C4")
# wavesynth.setPitch(wavesynth.C4)
# scales.arpeggio(0.25, [2, 3], 3)

# print("Testing arpeggio(0.18, [3, 4, 5], 2) from C3")
# wavesynth.setPitch(wavesynth.C3)
# scales.arpeggio(0.18, [3, 4, 5], 2)

# print("Running scalesDesign()...")
# wavesynth.setPitch(wavesynth.A3)
# scales.scalesDesign()

print("Saving track as scales.wav...")
wavesynth.saveTrack("scales.wav")
print("...done saving track; attempting to play track...")
try:
    wavesynth.playTrack()
    print("...done.")
except NotImplementedError:
    print(
        "To play music directly, install the `simpleaudio` module"
      + " via the Manage Packages option in the Tools menu."
    )
