"""
Authors: Peter Mawhorter
Consulted:
Date: 2022-3-1
Purpose: Tests for the scales task which makes ascending note sequences.

(use the play_scales.py file to play scales instead of just testing
them.)
"""

import optimism

import wavesynth

import scales

if hasattr(scales, "scale"):
    for (startingPitch, duration, notes, result) in [
        ("C4", 1, 4, ["C4", "D4", "E4", "F4"]),
        ("D4", 1.5, 6, ["D4", "E4", "F4", "G4", "A4", "B4"]),
        ("A3", 2, 5, ["A3", "B3", "C4", "D4", "E4"])
    ]:
        block = f"""\
wavesynth.setPitch(wavesynth.{startingPitch})
scales.scale({duration}, {notes})
wavesynth.printTrack()"""
        wavesynth.resetTracks()
        tester = optimism.testBlock(block)
        noteDuration = duration / notes
        tester.case(wavesynth=wavesynth, scales=scales).checkPrintedLines(
            f"a {noteDuration}s keyboard note at {result[0]} (60% vol)",
            *[
                f"and a {noteDuration}s keyboard note at {pitch} (60% vol)"
                for pitch in result[1:]
            ]
        )

if hasattr(scales, "unevenScale"):
    for (startingPitch, notes, startDuration, otherDuration, result) in [
        (
            "C4", 4, 0.5, 0.25,
            [("C4", 0.5), ("D4", 0.25), ("E4", 0.5), ("F4", 0.25)]
        ),
        (
            "C4", 5, 0.5, 0.25,
            [("C4", 0.5), ("D4", 0.25), ("E4", 0.5), ("F4", 0.25), ("G4", 0.5)]
        ),
        (
            "A4", 7, 0.2, 0.15,
            [
                ("A4", 0.2),
                ("B4", 0.15),
                ("C5", 0.2),
                ("D5", 0.15),
                ("E5", 0.2),
                ("F5", 0.15),
                ("G5", 0.2),
            ]
        ),
    ]:
        block = f"""\
wavesynth.setPitch(wavesynth.{startingPitch})
scales.unevenScale({notes}, {startDuration}, {otherDuration})
wavesynth.printTrack()"""
        wavesynth.resetTracks()
        tester = optimism.testBlock(block)
        tester.case(wavesynth=wavesynth, scales=scales).checkPrintedLines(
            f"a {result[0][1]}s keyboard note at {result[0][0]} (60% vol)",
            *[
                f"and a {duration}s keyboard note at {pitchName} (60% vol)"
                for (pitchName, duration) in result[1:]
            ]
        )

if hasattr(scales, "arpeggio"):
    for (startingPitch, duration, intervals, cycles) in [
        ("C4", 0.2, [4, 3, 5], 2),
        ("C4", 0.3, [3, 4, 5], 3),
        ("A4", 0.25, [2], 8)
    ]:
        block = f"""\
wavesynth.setPitch(wavesynth.{startingPitch})
scales.arpeggio({duration}, {intervals}, {cycles})
wavesynth.printTrack()"""
        wavesynth.resetTracks()
        tester = optimism.testBlock(block)
        pitchNow = getattr(wavesynth, startingPitch)
        pitchNames = []
        for interval in intervals * cycles:
            pitchNames.append(wavesynth.pitchName(pitchNow))
            pitchNow = wavesynth.halfStepUpFrom(pitchNow, interval)
        pitchNames.append(wavesynth.pitchName(pitchNow))

        tester.case(wavesynth=wavesynth, scales=scales).checkPrintedLines(
            f"a {duration}s keyboard note at {pitchNames[0]} (60% vol)",
            *[
                f"and a {duration}s keyboard note at {pname} (60% vol)"
                for pname in pitchNames[1:]
            ]
        )
