"""
Authors: Peter Mawhorter
Consulted:
Date: 2024-2-5
Purpose: Testing code for treeParts task. Checks each function if
it's been defined, looking for the right function calls. Without knowing
what arguments they'll use, it cannot test them. If you want to test
whether one of your functions correctly maintains the turtle position
invariant, call the "testInvariant"
"""

import optimism
import turtle
import turtleBeads

turtleBeads.noTrace()
import treeParts


def anyDrawingFunctionCall():
    "Returns a new MatchAny reqiurement for calling any drawing function"
    return optimism.MatchAny(
        optimism.Call("fd"),
        optimism.Call("forward"),
        optimism.Call("circle"),
        optimism.Call("drawCircle"),
        optimism.Call("drawEllipse"),
        optimism.Call("drawDot"),
        optimism.Call("drawSquare"),
        optimism.Call("drawRectangle"),
        optimism.Call("drawPolygon"),
        optimism.Call("drawText")
    )


def anyTurningFunctionCall():
    "Returns a new MatchAny reqiurement for calling any turning function"
    return optimism.MatchAny(
        optimism.Call("lt"),
        optimism.Call("rt"),
        optimism.Call("left"),
        optimism.Call("right")
    )

print()
print("Start of testing...")

testLeaf = optimism.testFunctionMaybe(treeParts, "leaf")
testLeaf.checkCodeContains(anyDrawingFunctionCall())

testTwig = optimism.testFunctionMaybe(treeParts, "twig")
testTwig.checkCodeContains(anyDrawingFunctionCall())
testTwig.checkCodeContains(optimism.Call("leaf", min=2))

testBranch = optimism.testFunctionMaybe(treeParts, "branch")
testBranch.checkCodeContains(anyDrawingFunctionCall())
testBranch.checkCodeContains(anyTurningFunctionCall())
testBranch.checkCodeContains(optimism.Call("twig", min=2))

testTree = optimism.testFunctionMaybe(treeParts, "tree")
testTree.checkCodeContains(anyDrawingFunctionCall())
testTree.checkCodeContains(anyTurningFunctionCall())
testTree.checkCodeContains(optimism.Call("branch", min=2))

testMain = optimism.testFunctionMaybe(treeParts, "main")
testMain.checkCodeContains(optimism.Call("tree"))


def exampleTwig():
    """
    Testing function to call twig with appropriate arguments. You
    designed twig, so you need to fill this in yourself for it to work.

    Replace the '...' with whatever arguments your twig function needs.
    """
    treeParts.twig(...)


def exampleBranch():
    """
    Testing function for branch. Fill in the arguments yourself.
    """
    treeParts.branch(...)


def exampleTree():
    """
    Testing function for tree. Fill in the arguments yourself.
    """
    treeParts.tree(...)


def testInvariant(function, x, y, h):
    """
    Runs invariant tests for a specific function with a specific starting
    position & angle.
    """
    print(f"Checking for position changes in {function.__name__}...")
    print(f"Starting at ({x}, {y}) with heading {h}...")
    turtleBeads.setupTurtle()
    turtleBeads.teleport(float(x), float(y))
    turtle.setheading(float(h))
    function()
    turtleBeads.showPicture()
    optimism.expect(turtle.xcor(), float(x))
    optimism.expect(turtle.ycor(), float(y))
    optimism.expect(turtle.heading(), float(h))
    print(f"...final position is: ({turtle.xcor()}, {turtle.ycor()})")
    print(f"...final heading is: {turtle.heading()}")


def testInvariants():
    """
    Runs invariant tests for twig, branch, and tree, but only works if
    you've filled in the example functions above.
    """
    turtleBeads.beSilent()
    testInvariant(exampleTwig, 0, 0, 0)
    testInvariant(exampleTwig, 30, -40, 210)
    testInvariant(exampleBranch, 0, 0, 0)
    testInvariant(exampleBranch, 20, -10, 330)
    testInvariant(exampleTree, 0, 0, 0)
    testInvariant(exampleTree, 10, 10, 80)
    turtleBeads.beLoud()


# TODO: Uncomment this if you want to test invariants. You will need to
# fill out the missing arguments in the example functions above for this
# to work.
testInvariants()
