"""
Authors:
Consulted:
Date: 2024-02-04
Purpose: treeParts task: draws trees using several functions.
"""

# Import basic drawing functions
from turtleBeads import *
from turtle import *


#----------------------#
# Provided (Subtask A) #
#----------------------#

def leaf(length, leafColor):
    """
    Draws a leaf based on the given length value. The leaf is just a
    thick line in the given color whose length is equal to the given
    length, and whose pen size is 1/2 of the length. The leaf extends
    forward from the turtle's starting position, and it returns to that
    starting location when it's done.

    This function returns the highest point on the leaf, which is just
    the higher of the two endpoints of the line it draws (not accounting
    for the pen size).

    This function changes the pen size and color as a side effect.
    """
    # Set the pen size and pen/fill colors
    pensize(2)
    pencolor(leafColor)
    fillcolor(leafColor)

    # Move forward without drawing
    leap(length / 2)

    # Draw a filled ellipse
    begin_fill()
    drawEllipse(length / (2 * 1.5), 1.5)
    end_fill()

    # Move backwards to where we started (without drawing)
    leap(-length / 2)


#---------------------#
# Your code goes here #
#---------------------#
