"""
Author: 
Date: 
Description:

"""

import sys
import torch
import csv
from torch import nn
import numpy as np
from torch.utils.data import DataLoader
from spacy.tokenizer import Tokenizer
from spacy.lang.en import English

nlp = English()
tokenizer = nlp.tokenizer

EPOCHS = 5
BATCH_SIZE = 24
LR = 1e-3

device = "cuda" if torch.cuda.is_available() else "cpu"

#####################################################

def add_feature(feats,data,fn,names,name):
	for i,f in enumerate(feats):
		f.append(fn(data[i]))
	names.append(name)

def compute_features(data,norms=None):
	feats = [[] for d in data]
	names = []
	add_feature(feats,data,len,names,'Length')
	"""
	Insert more features here!
	"""

	if not norms:
		norms = feat_avgs(feats)
	scaled_feats = rescale_features(feats,norms)
	return [torch.tensor(f, dtype=torch.float32) for f in scaled_feats], names, norms


def feat_avgs(features):
	norms = []
	for i in range(len(features[0])):
		f = [d[i] for d in features]
		norms.append(sum(f)/len(f))
	return norms

def rescale_features(features,norms):
	all_scaled = []
	for line in features:
		scaled = [f/norms[i] for i,f in enumerate(line)]
		all_scaled.append(scaled)
	return all_scaled

#####################################################

def print_coefficients(model,train_features, feat_names,label_map):
	spacing = max([len(f) for f in feat_names])
	print("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~")
	print("Model weights (rows=features; columns=categories)")
	print("Feature: "+' '*(spacing-7)+'\t'.join(label_map.keys()))

	params =  list(model.parameters())
	weights = params[0]
	biases = params[1]

	#print weights
	for i,f in enumerate(feat_names): 
		ws = [float(v[i]) for v in weights]
		print(f+': '+' '*(spacing-len(f))+'\t'.join(map(lambda x:str(round(x,3)),ws)))
	
	#print biases
	ws = [float(v) for v in list(biases)]
	print("Bias: "+' '*(spacing-4)+'\t'.join(map(lambda x:str(round(x,3)),ws)))

#####################################################

def main():

	train_f = 'lyrics/train_drake_swift_beyonce.csv'
	test_f = 'lyrics/test_drake_swift_beyonce.csv'
	label_map = {"Taylor Swift":0,"Beyoncé":1,"Drake":2}

	# Which features are most informative for each class?
	#print_coefficients(model,train_feats,feat_names,label_map)

if __name__ == '__main__':
	main()